/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.Caches;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.RemovableCloseableIterator;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.impl.GroupFilter;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.impl.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceStatus;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.PersistenceEntryStreamSupplier;
import org.infinispan.stream.impl.local.PersistenceKeyStreamSupplier;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;
import org.infinispan.util.Closeables;
import org.infinispan.util.EntryWrapper;
import org.infinispan.util.LazyConcatIterator;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@MBean(objectName="CacheLoader", description="Component that handles loading entries from a CacheStore into memory.")
public class CacheLoaderInterceptor<K, V>
extends JmxStatsCommandInterceptor
implements EntryLoader<K, V>,
PersistenceManager.StoreChangeListener {
    private static final Log log = LogFactory.getLog(CacheLoaderInterceptor.class);
    protected final AtomicLong cacheLoads = new AtomicLong(0L);
    protected final AtomicLong cacheMisses = new AtomicLong(0L);
    @Inject
    protected PersistenceManager persistenceManager;
    @Inject
    protected CacheNotifier notifier;
    @Inject
    protected EntryFactory entryFactory;
    @Inject
    TimeService timeService;
    @Inject
    InternalEntryFactory iceFactory;
    @Inject
    InternalDataContainer<K, V> dataContainer;
    @Inject
    GroupManager groupManager;
    @Inject
    ComponentRef<Cache<K, V>> cache;
    @Inject
    KeyPartitioner partitioner;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    protected ExecutorService nonBlockingExecutor;
    protected boolean activation;
    private volatile boolean usingStores;
    private final ConcurrentMap<Object, CompletionStage<InternalCacheEntry<K, V>>> pendingLoads = new ConcurrentHashMap<Object, CompletionStage<InternalCacheEntry<K, V>>>();

    @Start
    public void start() {
        this.activation = this.cacheConfiguration.persistence().passivation();
        this.usingStores = this.cacheConfiguration.persistence().usingStores();
    }

    @Override
    public void storeChanged(PersistenceStatus persistenceStatus) {
        this.usingStores = persistenceStatus.isEnabled();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) {
        return this.visitManyDataCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    private Object visitManyDataCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) {
        AggregateCompletionStage<Void> stage = null;
        for (Object key : keys) {
            CompletionStage<?> innerStage = this.loadIfNeeded(ctx, key, command);
            if (innerStage == null || CompletionStages.isCompletedSuccessfully(innerStage)) continue;
            if (stage == null) {
                stage = CompletionStages.aggregateCompletionStage();
            }
            stage.dependsOn(innerStage);
        }
        if (stage != null) {
            return this.asyncInvokeNext(ctx, (VisitableCommand)command, stage.freeze());
        }
        return this.invokeNext(ctx, command);
    }

    private Object visitDataCommand(InvocationContext ctx, AbstractDataCommand command) {
        CompletionStage<?> stage = null;
        Object key = command.getKey();
        if (key != null) {
            stage = this.loadIfNeeded(ctx, key, command);
        }
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, stage);
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) {
        if (!command.isGroupOwner() || this.hasSkipLoadFlag(command)) {
            return this.invokeNext(ctx, command);
        }
        Predicate<Object> keyFilter = new GroupFilter(command.getGroupName(), this.groupManager).and(k -> ctx.lookupEntry(k) == null);
        Publisher publisher = this.persistenceManager.publishEntries(keyFilter, true, false, PersistenceManager.AccessMode.BOTH);
        CompletionStage publisherStage = Flowable.fromPublisher(publisher).map(me -> PersistenceUtil.convert(me, this.iceFactory)).doOnNext(ice -> this.entryFactory.wrapExternalEntry(ctx, ice.getKey(), (CacheEntry)ice, true, false)).lastElement().toCompletionStage(null);
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, publisherStage);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        boolean isRemoteIteration = command.hasAnyFlag(FlagBitSets.REMOTE_ITERATION);
        command.addFlags(FlagBitSets.REMOTE_ITERATION);
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (this.hasSkipLoadFlag(command)) {
                return rv;
            }
            CacheSet entrySet = (CacheSet)rv;
            return new WrappedEntrySet(command, isRemoteIteration, entrySet);
        });
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        boolean isRemoteIteration = command.hasAnyFlag(FlagBitSets.REMOTE_ITERATION);
        command.addFlags(FlagBitSets.REMOTE_ITERATION);
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (this.hasSkipLoadFlag(command)) {
                return rv;
            }
            CacheSet keySet = (CacheSet)rv;
            return new WrappedKeySet(command, isRemoteIteration, keySet);
        });
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) {
        return this.visitManyDataCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.visitManyDataCommand(ctx, command, command.getAffectedKeys());
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.visitManyDataCommand(ctx, command, command.getAffectedKeys());
    }

    @Override
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) {
        CompletionStage<Long> sizeStage = this.trySizeOptimization(command.getFlagsBitSet());
        return CacheLoaderInterceptor.asyncValue(sizeStage).thenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if ((Long)rv == -1L) {
                return super.visitSizeCommand(rCtx, (SizeCommand)rCommand);
            }
            return rv;
        });
    }

    private CompletionStage<Long> trySizeOptimization(long flagBitSet) {
        if (EnumUtil.containsAny((long)flagBitSet, (long)(FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_SIZE_OPTIMIZATION))) {
            return NonBlockingStore.SIZE_UNAVAILABLE_FUTURE;
        }
        return this.persistenceManager.size(PersistenceManager.AccessMode.SHARED.and(PersistenceManager.AccessMode.NOT_ASYNC));
    }

    protected final boolean isConditional(WriteCommand cmd) {
        return cmd.isConditional();
    }

    protected final boolean hasSkipLoadFlag(FlagAffectedCommand cmd) {
        return cmd.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD);
    }

    protected boolean canLoad(Object key, int segment) {
        return true;
    }

    protected final CompletionStage<?> loadIfNeeded(InvocationContext ctx, Object key, FlagAffectedCommand cmd) {
        int segment = SegmentSpecificCommand.extractSegment(cmd, key, this.partitioner);
        if (this.skipLoad(ctx, key, segment, cmd)) {
            return null;
        }
        return this.loadInContext(ctx, key, segment, cmd);
    }

    protected CompletionStage<?> loadInContext(InvocationContext ctx, Object key, int segment, FlagAffectedCommand cmd) {
        CompletableFuture<InternalCacheEntry<K, V>> cf = new CompletableFuture<InternalCacheEntry<K, V>>();
        CompletionStage otherCF = this.pendingLoads.putIfAbsent(key, cf);
        if (otherCF != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Piggybacking on concurrent load for key %s", key);
            }
            return otherCF.thenAcceptAsync(entry -> this.putInContext(ctx, key, cmd, (InternalCacheEntry<K, V>)entry), this.nonBlockingExecutor);
        }
        CompletionStage<InternalCacheEntry<K, V>> result = this.loadAndStoreInDataContainer(ctx, key, segment, cmd);
        if (CompletionStages.isCompletedSuccessfully(result)) {
            this.finishLoadInContext(ctx, key, cmd, cf, CompletionStages.join(result), null);
        } else {
            result.whenComplete((value, throwable) -> this.finishLoadInContext(ctx, key, cmd, cf, (InternalCacheEntry<K, V>)value, (Throwable)throwable));
        }
        return cf;
    }

    private void finishLoadInContext(InvocationContext ctx, Object key, FlagAffectedCommand cmd, CompletableFuture<InternalCacheEntry<K, V>> cf, InternalCacheEntry<K, V> value, Throwable throwable) {
        this.pendingLoads.remove(key);
        if (throwable != null) {
            cf.completeExceptionally(throwable);
        } else {
            this.putInContext(ctx, key, cmd, value);
            cf.complete(value);
        }
    }

    private void putInContext(InvocationContext ctx, Object key, FlagAffectedCommand cmd, InternalCacheEntry<K, V> entry) {
        CacheEntry contextEntry;
        if (entry != null) {
            this.entryFactory.wrapExternalEntry(ctx, key, entry, true, cmd instanceof WriteCommand);
        }
        if ((contextEntry = ctx.lookupEntry(key)) instanceof MVCCEntry) {
            ((MVCCEntry)contextEntry).setLoaded(true);
        }
    }

    @Override
    public CompletionStage<InternalCacheEntry<K, V>> loadAndStoreInDataContainer(InvocationContext ctx, Object key, int segment, FlagAffectedCommand cmd) {
        InternalCacheEntry<K, V> entry = this.dataContainer.peek(segment, key);
        boolean includeStores = true;
        if (entry != null) {
            if (!entry.canExpire() || !entry.isExpired(this.timeService.wallClockTime())) {
                return CompletableFuture.completedFuture(entry);
            }
            includeStores = false;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Loading entry for key %s", key);
        }
        CompletionStage<InternalCacheEntry<K, V>> resultStage = this.persistenceManager.loadFromAllStores(key, segment, ctx.isOriginLocal(), includeStores).thenApply(me -> {
            if (me != null) {
                InternalCacheEntry ice = PersistenceUtil.convert(me, this.iceFactory);
                if (this.getStatisticsEnabled()) {
                    this.cacheLoads.incrementAndGet();
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Loaded entry: %s for key %s from store and attempting to insert into data container", ice, key);
                }
                DataContainer.ComputeAction putIfAbsentOrExpired = (k, oldEntry, factory) -> {
                    if (!(oldEntry == null || oldEntry.canExpire() && oldEntry.isExpired(this.timeService.wallClockTime()))) {
                        return oldEntry;
                    }
                    if (ice.canExpire()) {
                        ice.touch(this.timeService.wallClockTime());
                    }
                    return ice;
                };
                this.dataContainer.compute(segment, key, putIfAbsentOrExpired);
                return ice;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Missed entry load for key %s from store", key);
            }
            if (this.getStatisticsEnabled()) {
                this.cacheMisses.incrementAndGet();
            }
            return null;
        });
        if (this.notifier.hasListener(CacheEntryLoaded.class) || this.notifier.hasListener(CacheEntryActivated.class)) {
            return resultStage.thenCompose(ice -> {
                if (ice != null) {
                    Object value = ice.getValue();
                    CompletionStage<Void> notificationStage = this.sendNotification(key, value, true, ctx, cmd);
                    notificationStage = notificationStage.thenCompose(v -> this.sendNotification(key, value, false, ctx, cmd));
                    return notificationStage.thenApply(ignore -> ice);
                }
                return CompletableFutures.completedNull();
            });
        }
        return resultStage;
    }

    private boolean skipLoad(InvocationContext ctx, Object key, int segment, FlagAffectedCommand cmd) {
        boolean skip;
        CacheEntry e = ctx.lookupEntry(key);
        if (e == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Skip load for command %s. Entry is not in the context.", cmd);
            }
            return true;
        }
        if (e.getValue() != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Skip load for command %s. Entry %s (skipLookup=%s) has non-null value.", cmd, e, e.skipLookup());
            }
            return true;
        }
        if (e.skipLookup()) {
            if (log.isTraceEnabled()) {
                log.tracef("Skip load for command %s. Entry %s (skipLookup=%s) is set to skip lookup.", cmd, e, e.skipLookup());
            }
            return true;
        }
        if (!cmd.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK) && !this.canLoad(key, segment)) {
            if (log.isTraceEnabled()) {
                log.tracef("Skip load for command %s. Cannot load the key.", cmd);
            }
            return true;
        }
        if (cmd instanceof WriteCommand) {
            skip = this.skipLoadForWriteCommand((WriteCommand)cmd, key, ctx);
            if (log.isTraceEnabled()) {
                log.tracef("Skip load for write command %s? %s", cmd, skip);
            }
        } else {
            skip = this.hasSkipLoadFlag(cmd);
            if (log.isTraceEnabled()) {
                log.tracef("Skip load for command %s?. %s", cmd, skip);
            }
        }
        return skip;
    }

    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        if (cmd.loadType() != VisitableCommand.LoadType.DONT_LOAD) {
            if (this.hasSkipLoadFlag(cmd)) {
                log.tracef("Skipping load for command that reads existing values %s", cmd);
                return true;
            }
            return false;
        }
        return true;
    }

    protected CompletionStage<Void> sendNotification(Object key, Object value, boolean pre, InvocationContext ctx, FlagAffectedCommand cmd) {
        CompletionStage<Void> stage = this.notifier.notifyCacheEntryLoaded(key, value, pre, ctx, cmd);
        if (this.activation) {
            stage = CompletionStages.isCompletedSuccessfully(stage) ? this.notifier.notifyCacheEntryActivated(key, value, pre, ctx, cmd) : CompletionStages.allOf(stage, this.notifier.notifyCacheEntryActivated(key, value, pre, ctx, cmd));
        }
        return stage;
    }

    @ManagedAttribute(description="Number of entries loaded from cache store", displayName="Number of cache store loads", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderLoads() {
        return this.cacheLoads.get();
    }

    @ManagedAttribute(description="Number of entries that did not exist in cache store", displayName="Number of cache store load misses", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderMisses() {
        return this.cacheMisses.get();
    }

    @Override
    public void resetStatistics() {
        this.cacheLoads.set(0L);
        this.cacheMisses.set(0L);
    }

    @ManagedAttribute(description="Returns a collection of cache loader types which are configured and enabled", displayName="Returns a collection of cache loader types which are configured and enabled")
    public Collection<String> getStores() {
        if (this.usingStores) {
            return this.persistenceManager.getStoresAsString();
        }
        return Collections.emptySet();
    }

    @ManagedOperation(description="Disable all stores of a given type, where type is a fully qualified class name of the cache loader to disable", displayName="Disable all stores of a given type")
    public void disableStore(@Parameter(name="storeType", description="Fully qualified class name of a store implementation") String storeType) {
        this.persistenceManager.disableStore(storeType);
    }

    private class WrappedKeySet
    extends AbstractLoaderSet<K>
    implements CacheSet<K> {
        private final Cache<K, ?> cache;
        private final boolean isRemoteIteration;

        public WrappedKeySet(KeySetCommand command, boolean isRemoteIteration, CacheSet<K> keySet) {
            super(keySet, command.getFlagsBitSet());
            this.cache = Caches.getCacheWithFlags(CacheLoaderInterceptor.this.cache.wired(), command);
            this.isRemoteIteration = isRemoteIteration;
        }

        @Override
        public boolean remove(Object o) {
            return o != null && this.cache.remove(o) != null;
        }

        @Override
        public CloseableIterator<K> iterator() {
            if (this.isRemoteIteration) {
                return this.innerIterator();
            }
            return new RemovableCloseableIterator(this.innerIterator(), arg_0 -> this.cache.remove(arg_0));
        }

        @Override
        protected CloseableIterator<K> innerIterator() {
            HashSet seenKeys = new HashSet(this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
            IteratorMapper localIterator = new IteratorMapper((Iterator)this.cacheSet.iterator(), k -> {
                seenKeys.add(k);
                return k;
            });
            Flowable flowable = Flowable.fromPublisher(CacheLoaderInterceptor.this.persistenceManager.publishKeys(k -> !seenKeys.contains(k), PersistenceManager.AccessMode.BOTH));
            return new LazyConcatIterator(localIterator, () -> Closeables.iterator(flowable, 128));
        }

        @Override
        protected AbstractLocalCacheStream.StreamSupplier<K, Stream<K>> supplier() {
            return new KeyStreamSupplier(this.cache, CacheLoaderInterceptor.this.partitioner, () -> StreamSupport.stream(this.spliterator(), false));
        }

        @Override
        public boolean contains(Object o) {
            boolean contains = false;
            if (o != null && !(contains = this.cacheSet.contains(o))) {
                MarshallableEntry me = CompletionStages.join(CacheLoaderInterceptor.this.persistenceManager.loadFromAllStores(o, true, true));
                contains = me != null;
            }
            return contains;
        }

        @Override
        protected CacheStream<K> getStream(boolean parallel) {
            return new LocalCacheStream(new PersistenceKeyStreamSupplier(this.cache, CacheLoaderInterceptor.this.partitioner::getSegment, this.cacheSet.stream(), CacheLoaderInterceptor.this.persistenceManager), parallel, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public Publisher<K> localPublisher(int segment) {
            Publisher inMemorySource = this.cacheSet.localPublisher(segment);
            IntSet segments = IntSets.immutableSet((int)segment);
            return this.getKeyPublisher(inMemorySource, segments);
        }

        @Override
        public Publisher<K> localPublisher(IntSet segments) {
            Publisher inMemorySource = this.cacheSet.localPublisher(segments);
            return this.getKeyPublisher(inMemorySource, segments);
        }

        private Publisher<K> getKeyPublisher(Publisher<K> inMemorySource, IntSet segments) {
            HashSet seenKeys = new HashSet(CacheLoaderInterceptor.this.dataContainer.sizeIncludingExpired(segments));
            return Flowable.concat((Publisher)Flowable.fromPublisher(inMemorySource).doOnNext(seenKeys::add), CacheLoaderInterceptor.this.persistenceManager.publishKeys(segments, k -> !seenKeys.contains(k), PersistenceManager.AccessMode.BOTH));
        }
    }

    private class WrappedEntrySet
    extends AbstractLoaderSet<CacheEntry<K, V>> {
        private final Cache<K, V> cache;
        private final boolean isRemoteIteration;

        public WrappedEntrySet(EntrySetCommand command, boolean isRemoteIteration, CacheSet<CacheEntry<K, V>> entrySet) {
            super(entrySet, command.getFlagsBitSet());
            this.cache = Caches.getCacheWithFlags(CacheLoaderInterceptor.this.cache.wired(), command);
            this.isRemoteIteration = isRemoteIteration;
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = this.toEntry(o);
            return entry != null && this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            if (this.isRemoteIteration) {
                return this.innerIterator();
            }
            return new IteratorMapper((Iterator)new RemovableCloseableIterator(this.innerIterator(), e -> this.cache.remove(e.getKey(), e.getValue())), e -> new EntryWrapper(this.cache, e));
        }

        @Override
        protected CloseableIterator<CacheEntry<K, V>> innerIterator() {
            HashSet seenKeys = new HashSet(this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
            IteratorMapper localIterator = new IteratorMapper((Iterator)this.cacheSet.iterator(), e -> {
                seenKeys.add(e.getKey());
                return e;
            });
            Flowable flowable = Flowable.fromPublisher(CacheLoaderInterceptor.this.persistenceManager.publishEntries(k -> !seenKeys.contains(k), true, true, PersistenceManager.AccessMode.BOTH));
            Flowable publisher = flowable.map(me -> PersistenceUtil.convert(me, CacheLoaderInterceptor.this.iceFactory));
            return new LazyConcatIterator(localIterator, () -> WrappedEntrySet.lambda$innerIterator$5((Publisher)publisher));
        }

        @Override
        protected AbstractLocalCacheStream.StreamSupplier<CacheEntry<K, V>, Stream<CacheEntry<K, V>>> supplier() {
            return new EntryStreamSupplier(this.cache, CacheLoaderInterceptor.this.partitioner, () -> StreamSupport.stream(this.spliterator(), false));
        }

        @Override
        public boolean contains(Object o) {
            MarshallableEntry me;
            Map.Entry entry;
            boolean contains = false;
            if (o != null && !(contains = this.cacheSet.contains(o)) && (entry = this.toEntry(o)) != null && (me = CompletionStages.join(CacheLoaderInterceptor.this.persistenceManager.loadFromAllStores(entry.getKey(), true, true))) != null) {
                contains = entry.getValue().equals(me.getValue());
            }
            return contains;
        }

        @Override
        protected CacheStream<CacheEntry<K, V>> getStream(boolean parallel) {
            return new LocalCacheStream(new PersistenceEntryStreamSupplier(this.cache, CacheLoaderInterceptor.this.iceFactory, CacheLoaderInterceptor.this.partitioner::getSegment, this.cacheSet.stream(), CacheLoaderInterceptor.this.persistenceManager), parallel, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public Publisher<CacheEntry<K, V>> localPublisher(int segment) {
            Publisher inMemorySource = this.cacheSet.localPublisher(segment);
            IntSet segments = IntSets.immutableSet((int)segment);
            return this.getCacheEntryPublisher(inMemorySource, segments);
        }

        @Override
        public Publisher<CacheEntry<K, V>> localPublisher(IntSet segments) {
            Publisher inMemorySource = this.cacheSet.localPublisher(segments);
            return this.getCacheEntryPublisher(inMemorySource, segments);
        }

        private Publisher<CacheEntry<K, V>> getCacheEntryPublisher(Publisher<CacheEntry<K, V>> inMemorySource, IntSet segments) {
            HashSet seenKeys = new HashSet(CacheLoaderInterceptor.this.dataContainer.sizeIncludingExpired(segments));
            Publisher loaderSource = CacheLoaderInterceptor.this.persistenceManager.publishEntries(segments, k -> !seenKeys.contains(k), true, true, PersistenceManager.AccessMode.BOTH);
            return Flowable.concat((Publisher)Flowable.fromPublisher(inMemorySource).doOnNext(ce -> seenKeys.add(ce.getKey())), (Publisher)Flowable.fromPublisher(loaderSource).map(me -> PersistenceUtil.convert(me, CacheLoaderInterceptor.this.iceFactory)));
        }

        private static /* synthetic */ CloseableIterator lambda$innerIterator$5(Publisher publisher) {
            return Closeables.iterator(publisher, 128);
        }
    }

    private abstract class AbstractLoaderSet<R>
    extends AbstractSet<R>
    implements CacheSet<R> {
        protected final CacheSet<R> cacheSet;
        protected final long commandFlagBitSet;

        AbstractLoaderSet(CacheSet<R> cacheSet, long commandFlagBitSet) {
            this.cacheSet = cacheSet;
            this.commandFlagBitSet = commandFlagBitSet;
        }

        protected abstract CloseableIterator<R> innerIterator();

        @Override
        public CloseableSpliterator<R> spliterator() {
            return new IteratorAsSpliterator.Builder<R>(this.innerIterator()).setCharacteristics(4353).get();
        }

        @Override
        public void clear() {
            CacheLoaderInterceptor.this.cache.wired().clear();
        }

        @Override
        public int size() {
            long size = (Long)CompletionStages.join(CacheLoaderInterceptor.this.trySizeOptimization(this.commandFlagBitSet));
            if (size >= 0L) {
                return (int)Math.min(size, Integer.MAX_VALUE);
            }
            long longSize = this.stream().count();
            if (longSize > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)longSize;
        }

        @Override
        public boolean isEmpty() {
            boolean empty = this.cacheSet.isEmpty();
            if (empty) {
                boolean emptyReturn;
                Single emptySingle = Flowable.fromPublisher(CacheLoaderInterceptor.this.persistenceManager.publishKeys(null, PersistenceManager.AccessMode.BOTH)).isEmpty();
                empty = emptyReturn = ((Boolean)emptySingle.blockingGet()).booleanValue();
            }
            return empty;
        }

        @Override
        public CacheStream<R> stream() {
            return this.getStream(false);
        }

        @Override
        public CacheStream<R> parallelStream() {
            return this.getStream(true);
        }

        protected abstract CacheStream<R> getStream(boolean var1);

        protected abstract AbstractLocalCacheStream.StreamSupplier<R, Stream<R>> supplier();
    }
}

