/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.security.BouncyIntegration;
import org.jboss.resteasy.security.smime.MultipartSignedInputImpl;
import org.jboss.resteasy.security.smime.SignedInput;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.util.Types;

@Provider
@Consumes(value={"multipart/signed"})
public class MultipartSignedReader
implements MessageBodyReader<SignedInput> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SignedInput.class.isAssignableFrom(type);
    }

    public SignedInput readFrom(Class<SignedInput> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException, WebApplicationException {
        Class baseType = null;
        Type baseGenericType = null;
        if (genericType != null && genericType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)genericType;
            baseGenericType = param.getActualTypeArguments()[0];
            baseType = Types.getRawType((Type)baseGenericType);
        }
        try {
            ByteArrayDataSource ds = new ByteArrayDataSource(entityStream, mediaType.toString());
            MimeMultipart mm = new MimeMultipart((DataSource)ds);
            MultipartSignedInputImpl input = new MultipartSignedInputImpl();
            input.setType(baseType);
            input.setGenericType(baseGenericType);
            input.setAnnotations(annotations);
            input.setBody(mm);
            Providers providers = (Providers)ResteasyContext.getContextData(Providers.class);
            input.setProviders(providers);
            return input;
        }
        catch (MessagingException e) {
            throw new ReaderException((Throwable)e);
        }
    }

    static {
        BouncyIntegration.init();
    }
}

