/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ClassMultiReleaseExtension {
    private ClassMultiReleaseExtension() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    static boolean shouldTransformToPropertyName(Method method) {
        return !method.getDeclaringClass().isRecord();
    }

    static boolean isSpecialAccessorMethod(Method method, Map<String, Property> classProperties) {
        return method.getDeclaringClass().isRecord() && method.getParameterCount() == 0 && !Void.TYPE.equals(method.getReturnType()) && classProperties.containsKey(method.getName());
    }

    static JsonbCreator findCreator(Class<?> clazz, Constructor<?>[] declaredConstructors, AnnotationIntrospector introspector) {
        if (clazz.isRecord() && declaredConstructors.length == 1) {
            return introspector.createJsonbCreator(declaredConstructors[0], null, clazz);
        }
        return null;
    }

    public static Optional<JsonbException> exceptionToThrow(Class<?> clazz) {
        if (clazz.isRecord() && clazz.getDeclaredConstructors().length > 1) {
            return Optional.of(new JsonbException(Messages.getMessage(MessageKeys.RECORD_MULTIPLE_CONSTRUCTORS, clazz)));
        }
        return Optional.empty();
    }
}

