/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.impl;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.container.spi.ContainedBeanImplementor;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.search.engine.service.beanresolver.spi.BeanResolver;
import org.hibernate.search.engine.service.beanresolver.spi.ReflectionBeanResolver;
import org.hibernate.search.util.impl.Closer;

final class HibernateOrmBeanContainerBeanResolver
implements BeanResolver {
    private static final BeanContainer.LifecycleOptions LIFECYCLE_OPTIONS = new BeanContainer.LifecycleOptions(){

        public boolean canUseCachedReferences() {
            return false;
        }

        public boolean useJpaCompliantCreation() {
            return false;
        }
    };
    private final BeanContainer beanContainer;
    private final ConcurrentHashMap<ContainedBeanImplementor, Object> beansToCleanup = new ConcurrentHashMap();
    private final BeanInstanceProducer fallbackInstanceProducer = new BeanInstanceProducer(){
        private final BeanResolver delegate = new ReflectionBeanResolver();

        public <B> B produceBeanInstance(Class<B> aClass) {
            return (B)this.delegate.resolve(aClass, aClass);
        }

        public <B> B produceBeanInstance(String s, Class<B> aClass) {
            throw new UnsupportedOperationException("Getting beans by name is not implemented yet");
        }
    };

    public HibernateOrmBeanContainerBeanResolver(BeanContainer beanContainer) {
        Objects.requireNonNull(beanContainer);
        this.beanContainer = beanContainer;
    }

    public <T> T resolve(Class<?> reference, Class<T> expectedClass) {
        ContainedBean containedBean = this.beanContainer.getBean(reference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        if (containedBean != null) {
            if (containedBean instanceof ContainedBeanImplementor) {
                this.beansToCleanup.put((ContainedBeanImplementor)containedBean, containedBean);
            }
            return expectedClass.cast(containedBean.getBeanInstance());
        }
        return null;
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.pushAll(ContainedBeanImplementor::release, (Iterable)this.beansToCleanup.keySet());
        }
    }
}

