/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.participant.at;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;
import org.jboss.jbossts.xts.recovery.participant.at.ATParticipantRecoveryRecord;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryModule;

public class XTSATRecoveryManagerImple
extends XTSATRecoveryManager {
    private boolean participantRecoveryStarted = false;
    private boolean coordinatorRecoveryStarted = false;
    private boolean subordinateCoordinatorRecoveryStarted = false;
    private boolean culledOrphanSubordinates = false;
    private HashMap<String, ATParticipantRecoveryRecord> recoveryMap = new HashMap();
    private HashMap<String, Uid> uidMap = new HashMap();
    private final List<XTSATRecoveryModule> recoveryModules = new ArrayList<XTSATRecoveryModule>();
    private TxLog txLog;
    private static final String type = ATParticipantRecoveryRecord.type();

    public XTSATRecoveryManagerImple(TxLog txLog) {
        this.txLog = txLog;
    }

    public static boolean isRecoveryManagerInitialised() {
        return theRecoveryManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRecoveryModule(XTSATRecoveryModule module) throws NullPointerException {
        if (module == null) {
            throw new NullPointerException("XTSATRecoveryModule value must be non-null");
        }
        List<XTSATRecoveryModule> list = this.recoveryModules;
        synchronized (list) {
            this.recoveryModules.add(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterRecoveryModule(XTSATRecoveryModule module) throws NoSuchElementException {
        List<XTSATRecoveryModule> list = this.recoveryModules;
        synchronized (list) {
            if (!this.recoveryModules.remove(module)) {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public boolean writeParticipantRecoveryRecord(ATParticipantRecoveryRecord participantRecoveryRecord) {
        OutputObjectState oos = new OutputObjectState();
        try {
            oos.packString(participantRecoveryRecord.getClass().getCanonicalName());
        }
        catch (IOException ioe) {
            RecoveryLogger.i18NLogger.warn_participant_at_XTSATRecoveryModule_1(participantRecoveryRecord.getId(), ioe);
            return false;
        }
        if (participantRecoveryRecord.saveState(oos)) {
            Uid uid = new Uid();
            try {
                this.txLog.write_committed(uid, type, oos);
                this.uidMap.put(participantRecoveryRecord.getId(), uid);
                return true;
            }
            catch (ObjectStoreException ose) {
                RecoveryLogger.i18NLogger.warn_participant_at_XTSATRecoveryModule_1(participantRecoveryRecord.getId(), ose);
            }
        }
        return false;
    }

    @Override
    public boolean deleteParticipantRecoveryRecord(String id) {
        Uid uid = this.uidMap.get(id);
        if (uid != null) {
            try {
                this.txLog.remove_committed(uid, type);
                this.uidMap.remove(id);
                return true;
            }
            catch (ObjectStoreException ose) {
                RecoveryLogger.i18NLogger.warn_participant_at_XTSATRecoveryModule_2(uid, id, ose);
            }
        }
        return false;
    }

    @Override
    public boolean isParticipantPresent(Uid uid) {
        return this.uidMap.get(uid.toString()) != null;
    }

    @Override
    public void addParticipantRecoveryRecord(Uid uid, ATParticipantRecoveryRecord participantRecoveryRecord) {
        String participantId = participantRecoveryRecord.getId();
        if (this.recoveryMap.get(participantId) == null && !participantRecoveryRecord.isActive()) {
            this.recoveryMap.put(participantId, participantRecoveryRecord);
            this.uidMap.put(participantId, uid);
        }
    }

    @Override
    public synchronized ATParticipantRecoveryRecord findParticipantRecoveryRecord(String id) {
        return this.recoveryMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverParticipants() {
        ArrayList<XTSATRecoveryModule> recoveryModulesCopy;
        this.setParticipantRecoveryStarted();
        List<XTSATRecoveryModule> list = this.recoveryModules;
        synchronized (list) {
            recoveryModulesCopy = new ArrayList<XTSATRecoveryModule>(this.recoveryModules);
        }
        Iterator<ATParticipantRecoveryRecord> participantIterator = this.iterator();
        while (participantIterator.hasNext()) {
            ATParticipantRecoveryRecord participantRecoveryRecord = participantIterator.next();
            if (participantRecoveryRecord.isActive()) {
                participantIterator.remove();
                continue;
            }
            Iterator moduleIterator = recoveryModulesCopy.iterator();
            boolean found = false;
            while (!found && moduleIterator.hasNext()) {
                XTSATRecoveryModule module = (XTSATRecoveryModule)moduleIterator.next();
                try {
                    if (!participantRecoveryRecord.restoreParticipant(module)) continue;
                    found = true;
                    participantRecoveryRecord.activate();
                    participantIterator.remove();
                }
                catch (Exception e) {
                    found = true;
                    RecoveryLogger.i18NLogger.warn_participant_at_XTSATRecoveryModule_3(participantRecoveryRecord.getId(), e);
                }
            }
            if (found) continue;
            RecoveryLogger.i18NLogger.warn_participant_at_XTSATRecoveryModule_4(participantRecoveryRecord.getId());
        }
        for (XTSATRecoveryModule recoveryModule : recoveryModulesCopy) {
            recoveryModule.endScan();
        }
        this.cullOrphanedSubordinates();
    }

    private void cullOrphanedSubordinates() {
        SubordinateATCoordinator[] coordinators;
        if (this.culledOrphanSubordinates || !this.subordinateCoordinatorRecoveryStarted || !this.participantRecoveryStarted) {
            return;
        }
        this.culledOrphanSubordinates = true;
        for (SubordinateATCoordinator coordinator : coordinators = SubordinateATCoordinator.listRecoveredCoordinators()) {
            if (!coordinator.getSubordinateType().equals("org.jboss.jbossts.xts.at.at.subordinate") || !coordinator.isOrphaned()) continue;
            RecoveryLogger.i18NLogger.warn_participant_at_XTSATRecoveryModule_5(coordinator.get_uid());
            coordinator.rollback();
        }
    }

    private synchronized Iterator<ATParticipantRecoveryRecord> iterator() {
        return this.recoveryMap.values().iterator();
    }

    private synchronized void setParticipantRecoveryStarted() {
        this.participantRecoveryStarted = true;
    }

    @Override
    public synchronized boolean isParticipantRecoveryStarted() {
        return this.participantRecoveryStarted;
    }

    @Override
    public synchronized boolean isCoordinatorRecoveryStarted() {
        return this.coordinatorRecoveryStarted;
    }

    @Override
    public synchronized boolean isSubordinateCoordinatorRecoveryStarted() {
        return this.subordinateCoordinatorRecoveryStarted;
    }

    @Override
    public synchronized void setCoordinatorRecoveryStarted() {
        this.coordinatorRecoveryStarted = true;
    }

    @Override
    public synchronized void setSubordinateCoordinatorRecoveryStarted() {
        this.subordinateCoordinatorRecoveryStarted = true;
        this.cullOrphanedSubordinates();
    }
}

