/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.as.jmx.RemotingConnectorService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Endpoint;

class RemotingConnectorAdd
extends AbstractAddStepHandler {
    static final RemotingConnectorAdd INSTANCE = new RemotingConnectorAdd();

    private RemotingConnectorAdd() {
        super(RemotingConnectorResource.REMOTE_JMX_CAPABILITY, new AttributeDefinition[]{RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT});
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName remotingCapability;
        boolean useManagementEndpoint = RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.resolveModelAttribute(context, model).asBoolean();
        if (!useManagementEndpoint) {
            context.requireOptionalCapability("org.wildfly.remoting.endpoint", RemotingConnectorResource.REMOTE_JMX_CAPABILITY.getName(), RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.getName());
            remotingCapability = context.getCapabilityServiceName("org.wildfly.remoting.endpoint", Endpoint.class);
        } else {
            remotingCapability = ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        ModelNode jmxSubsystemModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(parentAddress, true));
        String resolvedDomain = JMXSubsystemAdd.getDomainName(context, jmxSubsystemModel, "resolved");
        String expressionsDomain = JMXSubsystemAdd.getDomainName(context, jmxSubsystemModel, "expression");
        RemotingConnectorService.addService(context.getServiceTarget(), remotingCapability, resolvedDomain, expressionsDomain);
    }
}

