/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.util.NamespaceHelper;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static String makeServiceNameFromClassName(Class<?> clazz) {
        int inner;
        String name = clazz.getName();
        int last = name.lastIndexOf(46);
        if (last != -1) {
            name = name.substring(last + 1);
        }
        if ((inner = name.lastIndexOf(36)) != -1) {
            name = name.substring(inner + 1);
        }
        return name;
    }

    public static QName makeQualifiedNameFromClass(Class<?> clazz) {
        String namespace = NamespaceHelper.makeNamespaceFromClassName(clazz.getName(), "http");
        String localPart = ServiceUtils.makeServiceNameFromClassName(clazz);
        return new QName(namespace, localPart);
    }

    public static String getMethodName(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append('.');
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            sb.append(param.getName());
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }
}

