/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.engine.impl.ImmutableAnalyzerRegistry;
import org.hibernate.search.engine.impl.ImmutableNormalizerRegistry;
import org.hibernate.search.engine.impl.NormalizerRegistry;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.indexes.spi.IndexFamilyImplementor;
import org.hibernate.search.util.impl.Closer;

public class ImmutableSearchIntegration
implements SearchIntegration {
    private final IndexFamilyImplementor indexFamily;
    private final AnalyzerRegistry analyzerRegistry;
    private final NormalizerRegistry normalizerRegistry;

    public ImmutableSearchIntegration(IndexFamilyImplementor indexFamily, AnalyzerRegistry analyzerRegistry, NormalizerRegistry normalizerRegistry) {
        this.indexFamily = indexFamily;
        this.analyzerRegistry = new ImmutableAnalyzerRegistry(analyzerRegistry);
        this.normalizerRegistry = new ImmutableNormalizerRegistry(normalizerRegistry);
    }

    @Override
    public IndexFamilyImplementor getIndexFamily() {
        return this.indexFamily;
    }

    @Override
    public AnalyzerRegistry getAnalyzerRegistry() {
        return this.analyzerRegistry;
    }

    @Override
    public NormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(IndexFamilyImplementor::close, this.indexFamily);
            closer.push(AnalyzerRegistry::close, this.analyzerRegistry);
            closer.push(NormalizerRegistry::close, this.normalizerRegistry);
        }
    }
}

