/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.remoting;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ConsumerContext;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;

public abstract class SessionContext {
    protected ClientSessionInternal session;
    protected SendAcknowledgementHandler sendAckHandler;
    protected volatile RemotingConnection remotingConnection;
    protected final IDGenerator idGenerator = new SimpleIDGenerator(0L);

    public SessionContext(RemotingConnection remotingConnection) {
        this.remotingConnection = remotingConnection;
    }

    public ClientSessionInternal getSession() {
        return this.session;
    }

    public void setSession(ClientSessionInternal session) {
        this.session = session;
    }

    public abstract void resetName(String var1);

    public abstract int getReconnectID();

    public abstract void transferConnection(RemotingConnection var1);

    public abstract boolean reattachOnNewConnection(RemotingConnection var1) throws ActiveMQException;

    public RemotingConnection getRemotingConnection() {
        return this.remotingConnection;
    }

    public abstract void closeConsumer(ClientConsumer var1) throws ActiveMQException;

    public abstract void sendConsumerCredits(ClientConsumer var1, int var2);

    public abstract boolean supportsLargeMessage();

    protected void handleReceiveLargeMessage(ConsumerContext consumerID, ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveLargeMessage(consumerID, clientLargeMessage, largeMessageSize);
        }
    }

    protected void handleReceiveMessage(ConsumerContext consumerID, ClientMessageInternal message) throws Exception {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveMessage(consumerID, message);
        }
    }

    protected void handleReceiveContinuation(ConsumerContext consumerID, byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveContinuation(consumerID, chunk, flowControlSize, isContinues);
        }
    }

    protected void handleReceiveProducerCredits(SimpleString address, int credits) {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveProducerCredits(address, credits);
        }
    }

    protected void handleReceiveProducerFailCredits(SimpleString address, int credits) {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveProducerFailCredits(address, credits);
        }
    }

    public abstract int getCreditsOnSendingFull(Message var1);

    public abstract void sendFullMessage(ICoreMessage var1, boolean var2, SendAcknowledgementHandler var3, SimpleString var4) throws ActiveMQException;

    public abstract int sendInitialChunkOnLargeMessage(Message var1) throws ActiveMQException;

    public abstract int sendLargeMessageChunk(Message var1, long var2, boolean var4, boolean var5, byte[] var6, int var7, SendAcknowledgementHandler var8) throws ActiveMQException;

    public abstract int sendServerLargeMessageChunk(Message var1, long var2, boolean var4, boolean var5, byte[] var6, SendAcknowledgementHandler var7) throws ActiveMQException;

    public abstract void setSendAcknowledgementHandler(SendAcknowledgementHandler var1);

    public abstract SendAcknowledgementHandler getSendAcknowledgementHandler();

    @Deprecated
    public abstract void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, Integer var6, Boolean var7, Boolean var8, Boolean var9) throws ActiveMQException;

    @Deprecated
    public abstract void createSharedQueue(SimpleString var1, SimpleString var2, QueueAttributes var3) throws ActiveMQException;

    @Deprecated
    public abstract void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5) throws ActiveMQException;

    @Deprecated
    public abstract void createSharedQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4) throws ActiveMQException;

    public abstract void createSharedQueue(QueueConfiguration var1) throws ActiveMQException;

    public abstract void deleteQueue(SimpleString var1) throws ActiveMQException;

    @Deprecated
    public abstract void createAddress(SimpleString var1, Set<RoutingType> var2, boolean var3) throws ActiveMQException;

    public abstract void createAddress(SimpleString var1, EnumSet<RoutingType> var2, boolean var3) throws ActiveMQException;

    @Deprecated
    public abstract void createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5, boolean var6) throws ActiveMQException;

    @Deprecated
    public abstract void createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9) throws ActiveMQException;

    public abstract void createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9, Boolean var10, Boolean var11) throws ActiveMQException;

    public abstract void createQueue(SimpleString var1, SimpleString var2, boolean var3, boolean var4, QueueAttributes var5) throws ActiveMQException;

    public abstract void createQueue(QueueConfiguration var1) throws ActiveMQException;

    public abstract ClientSession.QueueQuery queueQuery(SimpleString var1) throws ActiveMQException;

    public abstract void forceDelivery(ClientConsumer var1, long var2) throws ActiveMQException;

    public abstract ClientSession.AddressQuery addressQuery(SimpleString var1) throws ActiveMQException;

    public abstract void simpleCommit() throws ActiveMQException;

    public abstract void simpleCommit(boolean var1) throws ActiveMQException;

    public abstract void simpleRollback(boolean var1) throws ActiveMQException;

    public abstract void sessionStart() throws ActiveMQException;

    public abstract void sessionStop() throws ActiveMQException;

    public abstract void sendACK(boolean var1, boolean var2, ClientConsumer var3, Message var4) throws ActiveMQException;

    public abstract void expireMessage(ClientConsumer var1, Message var2) throws ActiveMQException;

    public abstract void sessionClose() throws ActiveMQException;

    public abstract void addSessionMetadata(String var1, String var2) throws ActiveMQException;

    public abstract void addUniqueMetaData(String var1, String var2) throws ActiveMQException;

    public abstract void sendProducerCreditsMessage(int var1, SimpleString var2);

    public abstract void xaCommit(Xid var1, boolean var2) throws XAException, ActiveMQException;

    public abstract void xaEnd(Xid var1, int var2) throws XAException, ActiveMQException;

    public abstract void xaForget(Xid var1) throws XAException, ActiveMQException;

    public abstract int xaPrepare(Xid var1) throws XAException, ActiveMQException;

    public abstract Xid[] xaScan() throws ActiveMQException;

    public abstract void xaRollback(Xid var1, boolean var2) throws ActiveMQException, XAException;

    public abstract void xaStart(Xid var1, int var2) throws XAException, ActiveMQException;

    public abstract boolean configureTransactionTimeout(int var1) throws ActiveMQException;

    public abstract ClientConsumerInternal createConsumer(SimpleString var1, SimpleString var2, int var3, int var4, int var5, int var6, boolean var7, Executor var8, Executor var9) throws ActiveMQException;

    public abstract int recoverSessionTimeout() throws ActiveMQException;

    public abstract int getServerVersion();

    public abstract void recreateSession(String var1, String var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ActiveMQException;

    public abstract void recreateConsumerOnServer(ClientConsumerInternal var1, long var2, boolean var4) throws ActiveMQException;

    public abstract void xaFailed(Xid var1) throws ActiveMQException;

    public abstract void restartSession() throws ActiveMQException;

    public abstract void resetMetadata(HashMap<String, String> var1);

    public abstract int getDefaultConsumerWindowSize(SessionQueueQueryResponseMessage var1) throws ActiveMQException;

    public abstract void returnBlocking(ActiveMQException var1);

    public abstract void lockCommunications();

    public abstract void releaseCommunications();

    public abstract void cleanup();

    public abstract void linkFlowControl(SimpleString var1, ClientProducerCredits var2);

    public abstract boolean isWritable(ReadyListener var1);
}

