/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIDependencyProcessor;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIHttpHandlerServiceConfigurator;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIModelServiceConfigurator;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.DeploymentDefinition;

public class OpenAPIDocumentProcessor
implements DeploymentUnitProcessor {
    private static final String ENABLED = "mp.openapi.extensions.enabled";

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = context.getDeploymentUnit();
        if (((Boolean)unit.getAttachment(OpenAPIDependencyProcessor.ATTACHMENT_KEY)).booleanValue()) {
            Config config = ConfigProvider.getConfig((ClassLoader)((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader());
            if (!config.getOptionalValue(ENABLED, Boolean.class).orElse(Boolean.TRUE).booleanValue()) {
                MicroProfileOpenAPILogger.LOGGER.disabled(unit.getName());
                return;
            }
            ModelNode model = ((DeploymentResourceSupport)unit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT)).getDeploymentSubsystemModel("undertow");
            String serverName = model.get(DeploymentDefinition.SERVER.getName()).asString();
            String hostName = model.get(DeploymentDefinition.VIRTUAL_HOST.getName()).asString();
            ServiceTarget target = context.getServiceTarget();
            OpenAPIModelServiceConfigurator configurator = new OpenAPIModelServiceConfigurator(unit, serverName, hostName, config);
            ServiceName modelServiceName = configurator.getServiceName();
            try {
                if (context.getServiceRegistry().getService(modelServiceName) != null) {
                    throw new DuplicateServiceException(modelServiceName.getCanonicalName());
                }
                configurator.build(target).install();
                new OpenAPIHttpHandlerServiceConfigurator(configurator).build(target).install();
            }
            catch (DuplicateServiceException e) {
                MicroProfileOpenAPILogger.LOGGER.endpointAlreadyRegistered(hostName, unit.getName());
            }
        }
    }
}

