/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.logging;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String errorMarshallingObject = "ISPN000065: Exception while marshalling object: %s";
    private static final String failedClearingJdbcCacheStore = "ISPN008001: Failed clearing cache store";
    private static final String sqlFailureIntegratingState = "ISPN008003: SQL failure while integrating state into store";
    private static final String ioErrorUnmarshalling = "ISPN008009: I/O error while unmarshalling from stream";
    private static final String unexpectedClassNotFoundException = "ISPN008010: *UNEXPECTED* ClassNotFoundException.";
    private static final String errorCreatingTable = "ISPN008011: Error while creating table; used DDL statement: '%s'";
    private static final String connectionInJndiNotFound = "ISPN008015: Could not find a connection in jndi under the name '%s'";
    private static final String namingExceptionLookingUpConnection = "ISPN008016: Could not lookup connection with datasource %s";
    private static final String failedClosingNamingCtx = "ISPN008017: Failed to close naming context.";
    private static final String sqlFailureRetrievingConnection = "ISPN008018: Sql failure retrieving connection from datasource";
    private static final String sqlFailureClosingConnection = "ISPN008019: Issues while closing connection %s";
    private static final String sqlFailureUnexpected = "ISPN008022: Unexpected sql failure";
    private static final String failureClosingConnection = "ISPN008023: Failure while closing the connection to the database";
    private static final String sqlFailureStoringKey = "ISPN008024: Error while storing string key to database; key: '%s'";
    private static final String sqlFailureRemovingKeys = "ISPN008025: Error while removing string keys from database";
    private static final String invalidKey2StringMapper = "ISPN008026: In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.";
    private static final String sqlFailureReadingKey = "ISPN008027: SQL error while fetching stored entry with key: %s, lockingKey: %s";
    private static final String tableManipulationAttributeNotSet = "ISPN008028: Attribute '%s' has not been set";
    private static final String missingConnectionFactory = "ISPN008029: A ConnectionFactory has not been specified for this store";
    private static final String sqlFailureTxCommit = "ISPN008031: Error committing JDBC transaction";
    private static final String sqlFailureTxRollback = "ISPN008032: Error during rollback of JDBC transaction";
    private static final String prepareTxFailure = "ISPN008033: Exception encountered when preparing JDBC store Tx";
    private static final String twoWayKey2StringMapperIsMissing = "ISPN008036: Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s";
    private static final String sqlFailureWritingBatch = "ISPN008037: Error while writing entries in batch to the database:";
    private static final String sqlFailureDeletingBatch = "ISPN008038: Error whilst removing keys in batch from the database. Keys: %s";
    private static final String existingStoreNoSegmentation = "ISPN008039: The existing store was created without segmentation enabled";
    private static final String existingStoreSegmentMismatch = "ISPN008040: The existing store was created with %d segments configured, but the cache is configured with %d";
    private static final String sqlFailureMetaRetrieval = "ISPN008041: Error retrieving JDBC metadata";
    private static final String sqlFailureSize = "ISPN008042: SQL failure while retrieving size";
    private static final String primaryKeyMultipleColumnWithoutSchema = "ISPN008043: Primary key has multiple columns but no key message schema defined, which is required when there is more than one key column";
    private static final String valueMultipleColumnWithoutSchema = "ISPN008044: Multiple non key columns but no value message schema defined, which is required when there is more than one value column";
    private static final String keyNotInSchema = "ISPN008045: Primary key %s was not found in the key schema %s";
    private static final String valueNotInSchema = "ISPN008046: Additional value columns %s found that were not part of the schema, make sure the columns returned match the value schema %s";
    private static final String schemaNotFound = "ISPN008047: Schema not found for : %s";
    private static final String keyCannotEmbedWithEnum = "ISPN008048: Key cannot be embedded when the value schema %s is an enum";
    private static final String repeatedFieldsNotSupported = "ISPN008049: Repeated fields are not supported, found %s in schema %s";
    private static final String duplicateFieldInSchema = "ISPN008050: Duplicate name %s found for nested schema: %s";
    private static final String requiredSchemaFieldNotPresent = "ISPN008051: Schema contained a field %s that is required but wasn't found in the query for schema %s";
    private static final String primaryKeyPresentButNotEmbedded = "ISPN008052: Primary key %s was found in the value schema %s but embedded key was not true";
    private static final String deleteAndSelectQueryMismatchArguments2 = "ISPN008053: Delete and select queries do not have matching arguments. Delete was %s and select was %s";
    private static final String deleteAndSelectQueryMismatchArguments3 = "ISPN008054: Named parameter %s in upsert statement [%s] is not available in columns from selectAll statement [%s]";
    private static final String selectAllCannotHaveParameters = "ISPN008055: No parameters are allowed for select all statement %s";
    private static final String deleteAllCannotHaveParameters = "ISPN008056: No parameters are allowed for delete all statement %s";
    private static final String sizeCannotHaveParameters = "ISPN008057: No parameters are allowed for sizer statement %s";
    private static final String keyColumnsNotReturnedFromSelectAll = "ISPN008058: Not all key columns %s were returned from select all statement %s";
    private static final String namedParamNotReturnedFromSelect = "ISPN008059: Select parameter %s is not returned from select all statement %s, select statement is %s";
    private static final String nonTerminatedNamedParamInSql = "ISPN008060: Non-terminated named parameter declaration at position %d in statement: %s";
    private static final String invalidCharacterInSql = "ISPN008061: Invalid character %s at position %d in statement: %s";
    private static final String unnamedParametersNotAllowed = "ISPN008062: Unnamed parameters are not allowed, found one at %d in statement %s";
    private static final String tableNotInCorrectFormat = "ISPN008063: Provided table name %s is not in form of (<SCHEMA>.)<TABLE-NAME> where SCHEMA is optional";
    private static final String noPrimaryKeysFoundForTable = "ISPN008064: No primary keys found for table %s, check case sensitivity";
    private static final String noValueColumnForTable = "ISPN008065: No column found that wasn't a primary key for table: %s";
    private static final String unableToDetectDialect = "ISPN008066: Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are %s";
    private static final String requiredStatementsForQueryStoreLoader = "ISPN008067: The size, select and select all attributes must be set for a query store";
    private static final String requiredStatementsForQueryStoreWriter = "ISPN008068: The delete, delete all and upsert attributes must be set for a query store that allows writes";
    private static final String keyColumnsRequired = "ISPN008069: Key columns are required for QueryStore";
    private static final String messageNameRequiredIfEmbeddedKey = "ISPN008070: Message name must not be null if embedded key is true";
    private static final String tableNameMissing = "ISPN008071: Table name must be non null";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorMarshallingObject(Throwable ioe, Object obj) {
        this.log.logf(FQCN, Logger.Level.ERROR, ioe, this.errorMarshallingObject$str(), obj);
    }

    protected String errorMarshallingObject$str() {
        return errorMarshallingObject;
    }

    @Override
    public final void failedClearingJdbcCacheStore(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedClearingJdbcCacheStore$str(), new Object[0]);
    }

    protected String failedClearingJdbcCacheStore$str() {
        return failedClearingJdbcCacheStore;
    }

    @Override
    public final void sqlFailureIntegratingState(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureIntegratingState$str(), new Object[0]);
    }

    protected String sqlFailureIntegratingState$str() {
        return sqlFailureIntegratingState;
    }

    @Override
    public final void ioErrorUnmarshalling(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioErrorUnmarshalling$str(), new Object[0]);
    }

    protected String ioErrorUnmarshalling$str() {
        return ioErrorUnmarshalling;
    }

    @Override
    public final void unexpectedClassNotFoundException(ClassNotFoundException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unexpectedClassNotFoundException$str(), new Object[0]);
    }

    protected String unexpectedClassNotFoundException$str() {
        return unexpectedClassNotFoundException;
    }

    @Override
    public final void errorCreatingTable(String sql, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCreatingTable$str(), (Object)sql);
    }

    protected String errorCreatingTable$str() {
        return errorCreatingTable;
    }

    @Override
    public final void connectionInJndiNotFound(String dataSourceName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.connectionInJndiNotFound$str(), (Object)dataSourceName);
    }

    protected String connectionInJndiNotFound$str() {
        return connectionInJndiNotFound;
    }

    @Override
    public final void namingExceptionLookingUpConnection(String dataSourceName, NamingException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.namingExceptionLookingUpConnection$str(), (Object)dataSourceName);
    }

    protected String namingExceptionLookingUpConnection$str() {
        return namingExceptionLookingUpConnection;
    }

    @Override
    public final void failedClosingNamingCtx(NamingException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedClosingNamingCtx$str(), new Object[0]);
    }

    protected String failedClosingNamingCtx$str() {
        return failedClosingNamingCtx;
    }

    @Override
    public final void sqlFailureRetrievingConnection(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureRetrievingConnection$str(), new Object[0]);
    }

    protected String sqlFailureRetrievingConnection$str() {
        return sqlFailureRetrievingConnection;
    }

    @Override
    public final void sqlFailureClosingConnection(Connection conn, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureClosingConnection$str(), (Object)conn);
    }

    protected String sqlFailureClosingConnection$str() {
        return sqlFailureClosingConnection;
    }

    @Override
    public final void sqlFailureUnexpected(SQLException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.sqlFailureUnexpected$str(), new Object[0]);
    }

    protected String sqlFailureUnexpected$str() {
        return sqlFailureUnexpected;
    }

    @Override
    public final void failureClosingConnection(SQLException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failureClosingConnection$str(), new Object[0]);
    }

    protected String failureClosingConnection$str() {
        return failureClosingConnection;
    }

    @Override
    public final void sqlFailureStoringKey(Object lockingKey, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureStoringKey$str(), lockingKey);
    }

    protected String sqlFailureStoringKey$str() {
        return sqlFailureStoringKey;
    }

    @Override
    public final void sqlFailureRemovingKeys(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureRemovingKeys$str(), new Object[0]);
    }

    protected String sqlFailureRemovingKeys$str() {
        return sqlFailureRemovingKeys;
    }

    @Override
    public final void invalidKey2StringMapper(String where, String className) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidKey2StringMapper$str(), (Object)where, (Object)className);
    }

    protected String invalidKey2StringMapper$str() {
        return invalidKey2StringMapper;
    }

    @Override
    public final void sqlFailureReadingKey(Object key, Object lockingKey, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureReadingKey$str(), key, lockingKey);
    }

    protected String sqlFailureReadingKey$str() {
        return sqlFailureReadingKey;
    }

    protected String tableManipulationAttributeNotSet$str() {
        return tableManipulationAttributeNotSet;
    }

    @Override
    public final CacheConfigurationException tableManipulationAttributeNotSet(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableManipulationAttributeNotSet$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingConnectionFactory$str() {
        return missingConnectionFactory;
    }

    @Override
    public final CacheConfigurationException missingConnectionFactory() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingConnectionFactory$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void sqlFailureTxCommit(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureTxCommit$str(), new Object[0]);
    }

    protected String sqlFailureTxCommit$str() {
        return sqlFailureTxCommit;
    }

    @Override
    public final void sqlFailureTxRollback(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureTxRollback$str(), new Object[0]);
    }

    protected String sqlFailureTxRollback$str() {
        return sqlFailureTxRollback;
    }

    protected String prepareTxFailure$str() {
        return prepareTxFailure;
    }

    @Override
    public final PersistenceException prepareTxFailure(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.prepareTxFailure$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void twoWayKey2StringMapperIsMissing(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.twoWayKey2StringMapperIsMissing$str(), (Object)className);
    }

    protected String twoWayKey2StringMapperIsMissing$str() {
        return twoWayKey2StringMapperIsMissing;
    }

    protected String sqlFailureWritingBatch$str() {
        return sqlFailureWritingBatch;
    }

    @Override
    public final PersistenceException sqlFailureWritingBatch(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sqlFailureWritingBatch$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sqlFailureDeletingBatch$str() {
        return sqlFailureDeletingBatch;
    }

    @Override
    public final PersistenceException sqlFailureDeletingBatch(Iterable<Object> keys, Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sqlFailureDeletingBatch$str(), keys), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String existingStoreNoSegmentation$str() {
        return existingStoreNoSegmentation;
    }

    @Override
    public final CacheConfigurationException existingStoreNoSegmentation() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingStoreNoSegmentation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String existingStoreSegmentMismatch$str() {
        return existingStoreSegmentMismatch;
    }

    @Override
    public final CacheConfigurationException existingStoreSegmentMismatch(int existing, int cache) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingStoreSegmentMismatch$str(), existing, cache));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void sqlFailureMetaRetrieval(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureMetaRetrieval$str(), new Object[0]);
    }

    protected String sqlFailureMetaRetrieval$str() {
        return sqlFailureMetaRetrieval;
    }

    @Override
    public final void sqlFailureSize(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureSize$str(), new Object[0]);
    }

    protected String sqlFailureSize$str() {
        return sqlFailureSize;
    }

    protected String primaryKeyMultipleColumnWithoutSchema$str() {
        return primaryKeyMultipleColumnWithoutSchema;
    }

    @Override
    public final CacheConfigurationException primaryKeyMultipleColumnWithoutSchema() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.primaryKeyMultipleColumnWithoutSchema$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String valueMultipleColumnWithoutSchema$str() {
        return valueMultipleColumnWithoutSchema;
    }

    @Override
    public final CacheConfigurationException valueMultipleColumnWithoutSchema() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.valueMultipleColumnWithoutSchema$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyNotInSchema$str() {
        return keyNotInSchema;
    }

    @Override
    public final CacheConfigurationException keyNotInSchema(String primaryKeyName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyNotInSchema$str(), primaryKeyName, schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String valueNotInSchema$str() {
        return valueNotInSchema;
    }

    @Override
    public final CacheConfigurationException valueNotInSchema(List<String> columnNames, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.valueNotInSchema$str(), columnNames, schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String schemaNotFound$str() {
        return schemaNotFound;
    }

    @Override
    public final CacheConfigurationException schemaNotFound(String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.schemaNotFound$str(), schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyCannotEmbedWithEnum$str() {
        return keyCannotEmbedWithEnum;
    }

    @Override
    public final CacheConfigurationException keyCannotEmbedWithEnum(String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyCannotEmbedWithEnum$str(), schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String repeatedFieldsNotSupported$str() {
        return repeatedFieldsNotSupported;
    }

    @Override
    public final CacheConfigurationException repeatedFieldsNotSupported(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.repeatedFieldsNotSupported$str(), fieldName, schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateFieldInSchema$str() {
        return duplicateFieldInSchema;
    }

    @Override
    public final CacheConfigurationException duplicateFieldInSchema(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateFieldInSchema$str(), fieldName, schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiredSchemaFieldNotPresent$str() {
        return requiredSchemaFieldNotPresent;
    }

    @Override
    public final CacheConfigurationException requiredSchemaFieldNotPresent(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requiredSchemaFieldNotPresent$str(), fieldName, schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String primaryKeyPresentButNotEmbedded$str() {
        return primaryKeyPresentButNotEmbedded;
    }

    @Override
    public final CacheConfigurationException primaryKeyPresentButNotEmbedded(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.primaryKeyPresentButNotEmbedded$str(), fieldName, schemaName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String deleteAndSelectQueryMismatchArguments2$str() {
        return deleteAndSelectQueryMismatchArguments2;
    }

    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(List<String> deleteParams, List<String> selectParams) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.deleteAndSelectQueryMismatchArguments2$str(), deleteParams, selectParams));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String deleteAndSelectQueryMismatchArguments3$str() {
        return deleteAndSelectQueryMismatchArguments3;
    }

    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(String paramName, String upsertStatement, String selectStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.deleteAndSelectQueryMismatchArguments3$str(), paramName, upsertStatement, selectStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String selectAllCannotHaveParameters$str() {
        return selectAllCannotHaveParameters;
    }

    @Override
    public final CacheConfigurationException selectAllCannotHaveParameters(String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.selectAllCannotHaveParameters$str(), selectAllStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String deleteAllCannotHaveParameters$str() {
        return deleteAllCannotHaveParameters;
    }

    @Override
    public final CacheConfigurationException deleteAllCannotHaveParameters(String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.deleteAllCannotHaveParameters$str(), selectAllStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sizeCannotHaveParameters$str() {
        return sizeCannotHaveParameters;
    }

    @Override
    public final CacheConfigurationException sizeCannotHaveParameters(String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.sizeCannotHaveParameters$str(), selectAllStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyColumnsNotReturnedFromSelectAll$str() {
        return keyColumnsNotReturnedFromSelectAll;
    }

    @Override
    public final CacheConfigurationException keyColumnsNotReturnedFromSelectAll(String keyColumns, String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyColumnsNotReturnedFromSelectAll$str(), keyColumns, selectAllStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String namedParamNotReturnedFromSelect$str() {
        return namedParamNotReturnedFromSelect;
    }

    @Override
    public final CacheConfigurationException namedParamNotReturnedFromSelect(String paramName, String selectAllStatement, String selectStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.namedParamNotReturnedFromSelect$str(), paramName, selectAllStatement, selectStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonTerminatedNamedParamInSql$str() {
        return nonTerminatedNamedParamInSql;
    }

    @Override
    public final CacheConfigurationException nonTerminatedNamedParamInSql(int position, String sqlStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nonTerminatedNamedParamInSql$str(), position, sqlStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCharacterInSql$str() {
        return invalidCharacterInSql;
    }

    @Override
    public final CacheConfigurationException invalidCharacterInSql(char character, int position, String sqlStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidCharacterInSql$str(), Character.valueOf(character), position, sqlStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unnamedParametersNotAllowed$str() {
        return unnamedParametersNotAllowed;
    }

    @Override
    public final CacheConfigurationException unnamedParametersNotAllowed(int position, String sqlStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unnamedParametersNotAllowed$str(), position, sqlStatement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tableNotInCorrectFormat$str() {
        return tableNotInCorrectFormat;
    }

    @Override
    public final CacheConfigurationException tableNotInCorrectFormat(String tableName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableNotInCorrectFormat$str(), tableName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPrimaryKeysFoundForTable$str() {
        return noPrimaryKeysFoundForTable;
    }

    @Override
    public final CacheConfigurationException noPrimaryKeysFoundForTable(String tableName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noPrimaryKeysFoundForTable$str(), tableName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noValueColumnForTable$str() {
        return noValueColumnForTable;
    }

    @Override
    public final CacheConfigurationException noValueColumnForTable(String tableName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noValueColumnForTable$str(), tableName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetectDialect$str() {
        return unableToDetectDialect;
    }

    @Override
    public final CacheConfigurationException unableToDetectDialect(String supportedDialects) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToDetectDialect$str(), supportedDialects));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiredStatementsForQueryStoreLoader$str() {
        return requiredStatementsForQueryStoreLoader;
    }

    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreLoader() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requiredStatementsForQueryStoreLoader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiredStatementsForQueryStoreWriter$str() {
        return requiredStatementsForQueryStoreWriter;
    }

    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreWriter() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requiredStatementsForQueryStoreWriter$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyColumnsRequired$str() {
        return keyColumnsRequired;
    }

    @Override
    public final CacheConfigurationException keyColumnsRequired() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyColumnsRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageNameRequiredIfEmbeddedKey$str() {
        return messageNameRequiredIfEmbeddedKey;
    }

    @Override
    public final CacheConfigurationException messageNameRequiredIfEmbeddedKey() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.messageNameRequiredIfEmbeddedKey$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tableNameMissing$str() {
        return tableNameMissing;
    }

    @Override
    public final CacheConfigurationException tableNameMissing() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableNameMissing$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

