/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import java.lang.invoke.MethodHandles;
import org.apache.avro.Protocol;
import org.hibernate.search.indexes.serialization.avro.impl.ProtocolBuilderV1_0;
import org.hibernate.search.indexes.serialization.avro.impl.ProtocolBuilderV1_1;
import org.hibernate.search.indexes.serialization.avro.impl.ProtocolBuilderV1_2;
import org.hibernate.search.indexes.serialization.avro.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class KnownProtocols {
    public static final int MAJOR_VERSION = 1;
    public static final int LATEST_MINOR_VERSION = 2;
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private volatile Protocol v1_0 = null;
    private volatile Protocol v1_1 = null;
    private volatile Protocol v1_2 = null;
    private volatile boolean warned = false;

    Protocol getProtocol(int majorVersion, int minorVersion) {
        if (1 != majorVersion) {
            throw log.incompatibleProtocolVersion(majorVersion, minorVersion, 1, 2);
        }
        if (minorVersion == 2) {
            return this.getV1_2();
        }
        if (minorVersion == 1) {
            return this.getV1_1();
        }
        if (minorVersion == 0) {
            return this.getV1_0();
        }
        if (!this.warned) {
            this.warned = true;
            log.unexpectedMinorProtocolVersion(majorVersion, minorVersion, 2);
        }
        return this.getV1_2();
    }

    public Protocol getLatestProtocol() {
        return this.getProtocol(1, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol getV1_0() {
        Protocol p = this.v1_0;
        if (p == null) {
            KnownProtocols knownProtocols = this;
            synchronized (knownProtocols) {
                p = this.v1_0;
                if (p != null) {
                    return p;
                }
                this.v1_0 = p = new ProtocolBuilderV1_0().build();
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol getV1_1() {
        Protocol p = this.v1_1;
        if (p == null) {
            KnownProtocols knownProtocols = this;
            synchronized (knownProtocols) {
                p = this.v1_1;
                if (p != null) {
                    return p;
                }
                this.v1_1 = p = new ProtocolBuilderV1_1().build();
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol getV1_2() {
        Protocol p = this.v1_2;
        if (p == null) {
            KnownProtocols knownProtocols = this;
            synchronized (knownProtocols) {
                p = this.v1_2;
                if (p != null) {
                    return p;
                }
                this.v1_2 = p = new ProtocolBuilderV1_2().build();
            }
        }
        return p;
    }
}

