/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.host.HostDefinition;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostAddHandler
extends AbstractAddStepHandler {
    public static final OperationContext.AttachmentKey<Boolean> HOST_ADD_AFTER_BOOT = OperationContext.AttachmentKey.create(Boolean.class);
    public static final OperationContext.AttachmentKey<String> HOST_NAME = OperationContext.AttachmentKey.create(String.class);
    private static final RuntimeCapability<Void> HOST_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.host.controller", (boolean)false).build();
    public static final String OPERATION_NAME = "add";
    private static final SimpleAttributeDefinition PERSIST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-name", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();
    private static final SimpleAttributeDefinition IS_DOMAIN_CONTROLLER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"is-domain-controller", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode().set(Boolean.TRUE.booleanValue()))).setDeprecated(ModelVersion.create((int)6), false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("add", HostResolver.getResolver("host")).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).addParameter((AttributeDefinition)PERSIST_NAME).addParameter((AttributeDefinition)IS_DOMAIN_CONTROLLER).build();
    private final HostDefinition hostDefinition;

    public HostAddHandler(HostDefinition hostDefinition) {
        this.hostDefinition = hostDefinition;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ManagementResourceRegistration rootRegistration;
        PathAddress pa = context.getCurrentAddress();
        if (!pa.equals(PathAddress.EMPTY_ADDRESS)) {
            ModelNode cloned = operation.clone();
            cloned.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
            context.attach(HOST_NAME, (Object)pa.getLastElement().getValue());
            context.addStep(cloned, (OperationStepHandler)this, OperationContext.Stage.MODEL, true);
            return;
        }
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (!root.getChildrenNames("host").isEmpty()) {
            String exists = (String)root.getChildrenNames("host").iterator().next();
            throw HostControllerLogger.ROOT_LOGGER.cannotAddHostAlreadyRegistered(exists);
        }
        String hostName = (String)context.getAttachment(HOST_NAME);
        if (hostName == null) {
            throw HostControllerLogger.ROOT_LOGGER.nullHostName();
        }
        boolean persistName = false;
        if (operation.has("persist-name")) {
            persistName = operation.get("persist-name").asBoolean();
        }
        boolean isDomainController = true;
        if (operation.has("is-domain-controller")) {
            isDomainController = operation.get("is-domain-controller").asBoolean();
        }
        ModelNode dc = new ModelNode();
        if (isDomainController) {
            dc.get("local").setEmptyObject();
        } else {
            dc.get("remote").setEmptyObject();
        }
        if (!context.isBooting() && !isDomainController) {
            throw HostControllerLogger.ROOT_LOGGER.cannotAddSlaveHostAfterBoot();
        }
        context.registerCapability(HOST_RUNTIME_CAPABILITY);
        PathAddress hostAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)hostName)});
        LocalHostControllerInfo localHostControllerInfo = this.hostDefinition.getLocalHostControllerInfo();
        ((LocalHostControllerInfoImpl)localHostControllerInfo).setMasterDomainController(isDomainController || !context.isBooting());
        this.hostDefinition.registerHostModel(hostName);
        Resource rootResource = context.createResource(hostAddress);
        ModelNode model = rootResource.getModel();
        model.get("domain-controller").set(dc);
        this.hostDefinition.initCoreModel(model);
        if (isDomainController || !context.isBooting()) {
            rootRegistration = context.getResourceRegistrationForUpdate();
            ModelNode update = new ModelNode();
            update.get("address").set(hostAddress.toModelNode());
            update.get("operation").set("write-local-domain-controller");
            context.attach(HOST_ADD_AFTER_BOOT, (Object)(!context.isBooting() ? 1 : 0));
            context.addStep(update, rootRegistration.getOperationHandler(hostAddress, "write-local-domain-controller"), OperationContext.Stage.MODEL, true);
        }
        this.hostDefinition.initModelServices(context, hostAddress, rootResource);
        if (!context.isBooting() && persistName) {
            rootRegistration = context.getResourceRegistrationForUpdate();
            ModelNode name = new ModelNode();
            name.get("address").set(hostAddress.toModelNode());
            name.get("operation").set("write-attribute");
            name.get("name").set("name");
            name.get("value").set(hostName);
            context.addStep(name, rootRegistration.getOperationHandler(hostAddress, "write-attribute"), OperationContext.Stage.MODEL, false);
        }
    }
}

