/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class SslContextFactory {
    private static final Log log = LogFactory.getLog(SslContextFactory.class);
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_SSL_PROTOCOL;
    private static final String CLASSPATH_RESOURCE = "classpath:";
    private static final String DEFAULT_SSL_PROVIDER;
    private KeyStore keyStore;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private char[] keyStoreCertificatePassword;
    private String keyStoreType = "JKS";
    private String keyAlias;
    private KeyStore trustStore;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private String trustStoreType = "JKS";
    private String sslProtocol = DEFAULT_SSL_PROTOCOL;
    private String sslProvider = DEFAULT_SSL_PROVIDER;
    private boolean useNativeIfAvailable = true;
    private ClassLoader classLoader;

    public SslContextFactory keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public SslContextFactory keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslContextFactory keyStorePassword(String keyStorePassword) {
        if (keyStorePassword != null) {
            this.keyStorePassword = keyStorePassword.toCharArray();
        }
        return this;
    }

    public SslContextFactory keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslContextFactory keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        return this;
    }

    public SslContextFactory keyStoreCertificatePassword(String keyStoreCertificatePassword) {
        if (keyStoreCertificatePassword != null) {
            this.keyStoreCertificatePassword = keyStoreCertificatePassword.toCharArray();
        }
        return this;
    }

    public SslContextFactory keyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        return this;
    }

    public SslContextFactory keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SslContextFactory trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public SslContextFactory trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslContextFactory trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslContextFactory trustStorePassword(String trustStorePassword) {
        if (trustStorePassword != null) {
            this.trustStorePassword = trustStorePassword.toCharArray();
        }
        return this;
    }

    public SslContextFactory trustStoreType(String trustStoreType) {
        if (trustStoreType != null) {
            this.trustStoreType = trustStoreType;
        }
        return this;
    }

    public SslContextFactory sslProtocol(String sslProtocol) {
        if (sslProtocol != null) {
            this.sslProtocol = sslProtocol;
        }
        return this;
    }

    public SslContextFactory sslProvider(String sslProvider) {
        if (sslProvider != null) {
            this.sslProvider = sslProvider;
        }
        return this;
    }

    public SslContextFactory classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SSLContext getContext() {
        try {
            KeyManager[] keyManagers = null;
            if (this.keyStoreFileName != null || this.keyStore != null) {
                KeyManagerFactory kmf = this.getKeyManagerFactory();
                keyManagers = kmf.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (this.trustStoreFileName != null || this.trustStore != null) {
                TrustManagerFactory tmf = this.getTrustManagerFactory();
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext sslContext = this.sslProvider != null ? SSLContext.getInstance(this.sslProtocol, this.sslProvider) : SSLContext.getInstance(this.sslProtocol);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize SSL", e);
        }
    }

    public KeyManagerFactory getKeyManagerFactory() throws IOException, GeneralSecurityException {
        char[] keyPassword;
        if (this.keyStore == null) {
            this.keyStore = KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE);
            SslContextFactory.loadKeyStore(this.keyStore, this.keyStoreFileName, this.keyStorePassword, this.classLoader);
        }
        char[] cArray = keyPassword = this.keyStoreCertificatePassword == null ? this.keyStorePassword : this.keyStoreCertificatePassword;
        if (this.keyAlias != null) {
            if (this.keyStore.containsAlias(this.keyAlias) && this.keyStore.isKeyEntry(this.keyAlias)) {
                KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(keyPassword);
                KeyStore.Entry entry = this.keyStore.getEntry(this.keyAlias, passParam);
                this.keyStore = KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE);
                this.keyStore.load(null);
                this.keyStore.setEntry(this.keyAlias, entry, passParam);
            } else {
                throw new RuntimeException("No alias '" + this.keyAlias + "' in key store '" + this.keyStoreFileName + "'");
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.keyStore, keyPassword);
        return kmf;
    }

    public TrustManagerFactory getTrustManagerFactory() throws IOException, GeneralSecurityException {
        if (this.trustStore == null) {
            this.trustStore = KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : DEFAULT_KEYSTORE_TYPE);
            SslContextFactory.loadKeyStore(this.trustStore, this.trustStoreFileName, this.trustStorePassword, this.classLoader);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(this.trustStore);
        return tmf;
    }

    public static String getSslProvider() {
        return DEFAULT_SSL_PROVIDER;
    }

    public static SSLEngine getEngine(SSLContext sslContext, boolean useClientMode, boolean needClientAuth) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(useClientMode);
        sslEngine.setNeedClientAuth(needClientAuth);
        return sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(KeyStore ks, String keyStoreFileName, char[] keyStorePassword, ClassLoader classLoader) throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            if (keyStoreFileName.startsWith(CLASSPATH_RESOURCE)) {
                String fileName = keyStoreFileName.substring(keyStoreFileName.indexOf(":") + 1);
                is = Util.getResourceAsStream(fileName, classLoader);
                if (is == null) {
                    throw new IllegalArgumentException("Cannot find `" + keyStoreFileName + "`");
                }
            } else {
                is = new BufferedInputStream(new FileInputStream(keyStoreFileName));
            }
            ks.load(is, keyStorePassword);
        }
        catch (Throwable throwable) {
            Util.close(is);
            throw throwable;
        }
        Util.close((Closeable)is);
    }

    static {
        String sslProtocol = null;
        String sslProvider = null;
        try {
            SSLContext context = SSLContext.getDefault();
            sslProvider = context.getProvider().getName();
            sslProtocol = context.getProtocol();
        }
        catch (Throwable context) {
            // empty catch block
        }
        DEFAULT_SSL_PROTOCOL = sslProtocol;
        try {
            Class openSslProvider = Util.loadClass("org.wildfly.openssl.OpenSSLProvider", SslContextFactory.class);
            Class openSsl = Util.loadClass("org.wildfly.openssl.SSL", SslContextFactory.class);
            if (openSslProvider != null && openSsl != null) {
                openSslProvider.getMethod("register", new Class[0]).invoke(null, new Object[0]);
                openSsl.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                sslProvider = "openssl";
                log.debug("Using OpenSSL");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_SSL_PROVIDER = sslProvider;
    }
}

