/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.jwt.smallrye;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.wildfly.extension.microprofile.jwt.smallrye.JwtDeploymentMarker;
import org.wildfly.extension.microprofile.jwt.smallrye._private.MicroProfileJWTLogger;

class JwtActivationProcessor
implements DeploymentUnitProcessor {
    private static final String AUTH_METHOD = "authMethod";
    private static final String REALM_NAME = "realmName";
    private static final String JWT_AUTH_METHOD = "MP-JWT";
    private static final DotName APPLICATION_DOT_NAME = DotName.createSimple((String)"javax.ws.rs.core.Application");
    private static final DotName LOGIN_CONFIG_DOT_NAME = DotName.createSimple((String)"org.eclipse.microprofile.auth.LoginConfig");

    JwtActivationProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        LoginConfigMetaData loginConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData mergedMetaData = warMetaData.getMergedJBossWebMetaData();
        LoginConfigMetaData loginConfigMetaData = loginConfig = mergedMetaData != null ? mergedMetaData.getLoginConfig() : null;
        if (loginConfig != null && !JWT_AUTH_METHOD.equals(loginConfig.getAuthMethod())) {
            return;
        }
        if (loginConfig == null) {
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            List annotations = index.getAnnotations(LOGIN_CONFIG_DOT_NAME);
            for (AnnotationInstance annotation : annotations) {
                AnnotationTarget target = annotation.target();
                if (target.kind() == AnnotationTarget.Kind.CLASS && this.extendsApplication(target.asClass(), index)) {
                    loginConfig = new LoginConfigMetaData();
                    AnnotationValue authMethodValue = annotation.value(AUTH_METHOD);
                    if (authMethodValue == null) {
                        throw MicroProfileJWTLogger.ROOT_LOGGER.noAuthMethodSpecified();
                    }
                    loginConfig.setAuthMethod(authMethodValue.asString());
                    AnnotationValue realmNameValue = annotation.value(REALM_NAME);
                    if (realmNameValue != null) {
                        loginConfig.setRealmName(realmNameValue.asString());
                    }
                    mergedMetaData.setLoginConfig(loginConfig);
                    break;
                }
                MicroProfileJWTLogger.ROOT_LOGGER.loginConfigInvalidTarget(target.toString());
            }
        }
        if (loginConfig != null && JWT_AUTH_METHOD.equals(loginConfig.getAuthMethod())) {
            MicroProfileJWTLogger.ROOT_LOGGER.tracef("Activating JWT for deployment %s.", deploymentUnit.getName());
            JwtDeploymentMarker.mark(deploymentUnit);
            VirtualDomainMarkerUtility.virtualDomainRequired((DeploymentUnit)deploymentUnit);
        }
    }

    private boolean extendsApplication(ClassInfo classInfo, CompositeIndex index) {
        if (classInfo == null) {
            return false;
        }
        DotName superType = classInfo.superName();
        if (superType == null) {
            return false;
        }
        if (APPLICATION_DOT_NAME.equals((Object)superType)) {
            return true;
        }
        return this.extendsApplication(index.getClassByName(superType), index);
    }
}

