/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class ConnectionBase {
    private static final long METRICS_REPORTED_BYTES_LOW_MASK = 4095L;
    private static final long METRICS_REPORTED_BYTES_HIGH_MASK = -4096L;
    public static final VertxException CLOSED_EXCEPTION = new VertxException("Connection was closed", true);
    public static final AttributeKey<SocketAddress> REMOTE_ADDRESS_OVERRIDE = AttributeKey.valueOf((String)"RemoteAddressOverride");
    public static final AttributeKey<SocketAddress> LOCAL_ADDRESS_OVERRIDE = AttributeKey.valueOf((String)"LocalAddressOverride");
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    private static final int MAX_REGION_SIZE = 0x100000;
    public final VoidChannelPromise voidPromise;
    protected final VertxInternal vertx;
    protected final ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private int writeInProgress;
    private Object metric;
    private SocketAddress remoteAddress;
    private SocketAddress localAddress;
    private ChannelPromise closePromise;
    private Future<Void> closeFuture;
    private long remainingBytesRead;
    private long remainingBytesWritten;
    private boolean read;
    private boolean needsFlush;
    private boolean closed;

    protected ConnectionBase(ContextInternal context, ChannelHandlerContext chctx) {
        this.vertx = context.owner();
        this.chctx = chctx;
        this.context = context;
        this.voidPromise = new VoidChannelPromise(chctx.channel(), false);
        this.closePromise = chctx.newPromise();
        PromiseInternal p = context.promise();
        this.closePromise.addListener(p);
        this.closeFuture = p.future();
        this.closeFuture.onComplete(this::checkCloseHandler);
    }

    public Future<Void> closeFuture() {
        return this.closeFuture;
    }

    public void fail(Throwable error) {
        this.chctx.pipeline().fireExceptionCaught(error);
    }

    void close(ChannelPromise promise) {
        this.closePromise.addListener(l -> {
            if (l.isSuccess()) {
                promise.setSuccess();
            } else {
                promise.setFailure(l.cause());
            }
        });
        this.close();
    }

    final void endReadAndFlush() {
        if (this.read) {
            this.read = false;
            if (this.needsFlush) {
                this.needsFlush = false;
                this.chctx.flush();
            }
        }
    }

    final void read(Object msg) {
        this.read = true;
        if (!this.closed) {
            if (Metrics.METRICS_ENABLED) {
                this.reportBytesRead(msg);
            }
            this.handleMessage(msg);
        } else {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private void write(Object msg, Boolean flush, ChannelPromise promise) {
        if (Metrics.METRICS_ENABLED) {
            this.reportsBytesWritten(msg);
        }
        boolean writeAndFlush = flush == null ? !this.read : flush;
        boolean bl = this.needsFlush = !writeAndFlush;
        if (writeAndFlush) {
            this.chctx.writeAndFlush(msg, promise);
        } else {
            this.chctx.write(msg, promise);
        }
    }

    private void writeClose(PromiseInternal<Void> promise) {
        if (this.closed) {
            promise.complete();
            return;
        }
        this.closed = true;
        ChannelPromise channelPromise = this.chctx.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)f -> this.chctx.close().addListener((GenericFutureListener)promise)));
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, channelPromise);
    }

    private ChannelPromise wrap(FutureListener<Void> handler) {
        ChannelPromise promise = this.chctx.newPromise();
        promise.addListener(handler);
        return promise;
    }

    public final void writeToChannel(Object msg, FutureListener<Void> listener) {
        this.writeToChannel(msg, (ChannelPromise)(listener == null ? this.voidPromise : this.wrap(listener)));
    }

    public final void writeToChannel(Object msg, ChannelPromise promise) {
        this.writeToChannel(msg, false, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToChannel(Object msg, boolean forceFlush, ChannelPromise promise) {
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (!this.chctx.executor().inEventLoop() || this.writeInProgress > 0) {
                this.queueForWrite(msg, forceFlush, promise);
                return;
            }
        }
        this.write(msg, forceFlush ? Boolean.valueOf(true) : null, promise);
    }

    private void queueForWrite(Object msg, boolean forceFlush, ChannelPromise promise) {
        ++this.writeInProgress;
        this.chctx.executor().execute(() -> {
            boolean flush;
            if (forceFlush) {
                flush = true;
            } else {
                ConnectionBase connectionBase = this;
                synchronized (connectionBase) {
                    flush = --this.writeInProgress == 0;
                }
            }
            this.write(msg, flush, promise);
        });
    }

    public void writeToChannel(Object obj) {
        this.writeToChannel(obj, (ChannelPromise)this.voidPromise);
    }

    public final void flush() {
        this.flush((ChannelPromise)this.voidPromise);
    }

    public final void flush(ChannelPromise promise) {
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, promise);
    }

    public boolean isNotWritable() {
        return !this.chctx.channel().isWritable();
    }

    public Future<Void> close() {
        PromiseInternal<Void> promise = this.context.promise();
        EventExecutor exec = this.chctx.executor();
        if (exec.inEventLoop()) {
            this.writeClose(promise);
        } else {
            exec.execute(() -> this.writeClose(promise));
        }
        return promise.future();
    }

    public final void close(Handler<AsyncResult<Void>> handler) {
        this.close().onComplete(handler);
    }

    public synchronized ConnectionBase closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    public synchronized ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    protected synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public void doPause() {
        this.chctx.channel().config().setAutoRead(false);
    }

    public void doResume() {
        this.chctx.channel().config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        ChannelConfig config = this.chctx.channel().config();
        config.setWriteBufferWaterMark(new WriteBufferWaterMark(size / 2, size));
    }

    public final Channel channel() {
        return this.chctx.channel();
    }

    public final ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    public final ContextInternal getContext() {
        return this.context;
    }

    public final synchronized void metric(Object metric) {
        this.metric = metric;
    }

    public final synchronized Object metric() {
        return this.metric;
    }

    public abstract NetworkMetrics metrics();

    protected void handleException(Throwable t) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.exceptionOccurred(this.metric, this.remoteAddress(), t);
        }
        this.context.emit(t, err -> {
            Handler<Throwable> handler;
            ConnectionBase connectionBase = this;
            synchronized (connectionBase) {
                handler = this.exceptionHandler;
            }
            if (handler != null) {
                handler.handle((Throwable)err);
            } else if (log.isDebugEnabled()) {
                log.error(t.getMessage(), t);
            } else {
                log.error(t.getMessage());
            }
        });
    }

    protected void handleClosed() {
        this.closed = true;
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            this.flushBytesRead();
            this.flushBytesWritten();
            if (metrics instanceof TCPMetrics) {
                ((TCPMetrics)metrics).disconnected(this.metric(), this.remoteAddress());
            }
        }
        this.closePromise.setSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCloseHandler(AsyncResult<Void> ar) {
        Handler<Void> handler;
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            handler = this.closeHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    protected void handleEvent(Object evt) {
        ReferenceCountUtil.release((Object)evt);
    }

    protected void handleIdle(IdleStateEvent event) {
        this.chctx.close();
    }

    protected abstract void handleInterestedOpsChanged();

    protected boolean supportsFileRegion() {
        return !this.isSsl();
    }

    protected void reportBytesRead(Object msg) {
    }

    public void reportBytesRead(long numberOfBytes) {
        if (numberOfBytes < 0L) {
            throw new IllegalArgumentException();
        }
        long bytes = this.remainingBytesRead;
        NetworkMetrics metrics = this.metrics();
        long val = (bytes += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
        if (metrics != null && val > 0L) {
            bytes &= 0xFFFL;
            metrics.bytesRead(this.metric(), this.remoteAddress(), val);
        }
        this.remainingBytesRead = bytes;
    }

    protected void reportsBytesWritten(Object msg) {
    }

    public void reportBytesWritten(long numberOfBytes) {
        if (numberOfBytes < 0L) {
            throw new IllegalArgumentException();
        }
        long bytes = this.remainingBytesWritten;
        NetworkMetrics metrics = this.metrics();
        long val = (bytes += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
        if (metrics != null && val > 0L) {
            bytes &= 0xFFFL;
            metrics.bytesWritten(this.metric, this.remoteAddress(), val);
        }
        this.remainingBytesWritten = bytes;
    }

    public void flushBytesRead() {
        long val = this.remainingBytesRead;
        if (val > 0L) {
            NetworkMetrics metrics = this.metrics();
            this.remainingBytesRead = 0L;
            if (metrics != null) {
                metrics.bytesRead(this.metric(), this.remoteAddress(), val);
            }
        }
    }

    public void flushBytesWritten() {
        long val = this.remainingBytesWritten;
        if (val > 0L) {
            NetworkMetrics metrics = this.metrics();
            this.remainingBytesWritten = 0L;
            if (metrics != null) {
                metrics.bytesWritten(this.metric(), this.remoteAddress(), val);
            }
        }
    }

    private void sendFileRegion(RandomAccessFile file, long offset, long length, ChannelPromise writeFuture) {
        if (length < 0x100000L) {
            this.writeToChannel((Object)new DefaultFileRegion(file.getChannel(), offset, length), writeFuture);
        } else {
            ChannelPromise promise = this.chctx.newPromise();
            DefaultFileRegion region = new DefaultFileRegion(file.getChannel(), offset, 0x100000L);
            region.retain();
            this.writeToChannel((Object)region, promise);
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    this.sendFileRegion(file, offset + 0x100000L, length - 0x100000L, writeFuture);
                } else {
                    log.error(future.cause().getMessage(), future.cause());
                    writeFuture.setFailure(future.cause());
                }
            });
        }
    }

    public final ChannelFuture sendFile(RandomAccessFile raf, long offset, long length) throws IOException {
        ChannelPromise writeFuture = this.chctx.newPromise();
        if (!this.supportsFileRegion()) {
            this.writeToChannel((Object)new ChunkedFile(raf, offset, length, 8192), writeFuture);
        } else {
            this.sendFileRegion(raf, offset, length, writeFuture);
        }
        if (writeFuture != null) {
            writeFuture.addListener(fut -> raf.close());
        } else {
            raf.close();
        }
        return writeFuture;
    }

    public boolean isSsl() {
        return this.chctx.pipeline().get(SslHandler.class) != null;
    }

    public SSLSession sslSession() {
        ChannelHandlerContext sslHandlerContext = this.chctx.pipeline().context(SslHandler.class);
        if (sslHandlerContext != null) {
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession();
        }
        return null;
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        SSLSession session = this.sslSession();
        if (session != null) {
            return session.getPeerCertificateChain();
        }
        return null;
    }

    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        SSLSession session = this.sslSession();
        if (session != null) {
            return Arrays.asList(session.getPeerCertificates());
        }
        return null;
    }

    public String indicatedServerName() {
        if (this.chctx.channel().hasAttr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR)) {
            return (String)this.chctx.channel().attr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR).get();
        }
        return null;
    }

    public ChannelPromise channelFuture() {
        return this.chctx.newPromise();
    }

    public String remoteName() {
        java.net.SocketAddress addr = this.chctx.channel().remoteAddress();
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getHostString();
        }
        return null;
    }

    public SocketAddress remoteAddress() {
        SocketAddress address = this.remoteAddress;
        if (address == null) {
            if (this.chctx.channel().hasAttr(REMOTE_ADDRESS_OVERRIDE)) {
                address = (SocketAddress)this.chctx.channel().attr(REMOTE_ADDRESS_OVERRIDE).getAndSet(null);
            } else {
                java.net.SocketAddress addr = this.chctx.channel().remoteAddress();
                if (addr != null) {
                    address = this.vertx.transport().convert(addr);
                }
            }
            if (address != null) {
                this.remoteAddress = address;
            }
        }
        return address;
    }

    public SocketAddress localAddress() {
        SocketAddress address = this.localAddress;
        if (address == null) {
            if (this.chctx.channel().hasAttr(LOCAL_ADDRESS_OVERRIDE)) {
                address = (SocketAddress)this.chctx.channel().attr(LOCAL_ADDRESS_OVERRIDE).getAndSet(null);
            } else {
                java.net.SocketAddress addr = this.chctx.channel().localAddress();
                if (addr != null) {
                    address = this.vertx.transport().convert(addr);
                }
            }
            if (address != null) {
                this.localAddress = address;
            }
        }
        return address;
    }

    protected void handleMessage(Object msg) {
    }
}

