/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.Locale;

enum DiscoverySchema {
    VERSION_1_0(1, 0);

    static final DiscoverySchema CURRENT;
    private final int major;
    private final int minor;

    private DiscoverySchema(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    int major() {
        return this.major;
    }

    int minor() {
        return this.minor;
    }

    String getNamespaceUri() {
        return String.format(Locale.ROOT, "urn:jboss:domain:%s:%d.%d", "discovery", this.major, this.minor);
    }

    boolean since(DiscoverySchema schema) {
        return this.major() > schema.major() || this.major() == schema.major() && this.minor() >= schema.minor();
    }

    static {
        CURRENT = VERSION_1_0;
    }
}

