/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class SimpleServerLoginModule
extends UsernamePasswordLoginModule {
    private SimplePrincipal user;
    private boolean guestOnly;

    @Override
    protected Principal getIdentity() {
        Principal principal = this.user;
        if (principal == null) {
            principal = super.getIdentity();
        }
        return principal;
    }

    @Override
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword == null) {
            this.guestOnly = true;
            isValid = true;
            this.user = new SimplePrincipal("guest");
        } else {
            isValid = inputPassword.equals(expectedPassword);
        }
        return isValid;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{new SimpleGroup("Roles")};
        if (!this.guestOnly) {
            roleSets[0].addMember((Principal)new SimplePrincipal("user"));
        }
        roleSets[0].addMember((Principal)new SimplePrincipal("guest"));
        return roleSets;
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        return this.getUsername();
    }

    @Override
    public boolean logout() throws LoginException {
        Group[] groups = this.getRoleSets();
        this.subject.getPrincipals().remove(groups[0]);
        return super.logout();
    }
}

