/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.Provider;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.password.spec.Encoding;

public class FileSystemSecurityRealmBuilder {
    private Path root;
    private NameRewriter nameRewriter;
    private int levels = 2;
    private boolean encoded = true;
    private Charset hashCharset;
    private Encoding hashEncoding;
    private SecretKey secretKey;
    private Supplier<Provider[]> providers;

    FileSystemSecurityRealmBuilder() {
    }

    public FileSystemSecurityRealmBuilder setRoot(Path root) {
        Assert.checkNotNullParam("root", root);
        this.root = root;
        return this;
    }

    public FileSystemSecurityRealmBuilder setNameRewriter(NameRewriter nameRewriter) {
        Assert.checkNotNullParam("nameRewriter", nameRewriter);
        this.nameRewriter = nameRewriter;
        return this;
    }

    public FileSystemSecurityRealmBuilder setLevels(int levels) {
        Assert.checkMinimumParameter("levels", 0, levels);
        this.levels = levels;
        return this;
    }

    public FileSystemSecurityRealmBuilder setEncoded(boolean encoded) {
        this.encoded = encoded;
        return this;
    }

    public FileSystemSecurityRealmBuilder setHashCharset(Charset hashCharset) {
        Assert.checkNotNullParam("hashCharset", hashCharset);
        this.hashCharset = hashCharset;
        return this;
    }

    public FileSystemSecurityRealmBuilder setHashEncoding(Encoding hashEncoding) {
        Assert.checkNotNullParam("hashEncoding", hashEncoding);
        this.hashEncoding = hashEncoding;
        return this;
    }

    public FileSystemSecurityRealmBuilder setSecretKey(SecretKey secretKey) {
        Assert.checkNotNullParam("secretKey", secretKey);
        this.secretKey = secretKey;
        return this;
    }

    public FileSystemSecurityRealmBuilder setProviders(Supplier<Provider[]> providers) {
        Assert.checkNotNullParam("providers", providers);
        this.providers = providers;
        return this;
    }

    public FileSystemSecurityRealm build() {
        boolean bl = this.encoded = this.secretKey == null && this.encoded;
        if (this.nameRewriter == null) {
            this.nameRewriter = NameRewriter.IDENTITY_REWRITER;
        }
        if (this.hashEncoding == null) {
            this.hashEncoding = Encoding.BASE64;
        }
        if (this.hashCharset == null) {
            this.hashCharset = StandardCharsets.UTF_8;
        }
        return new FileSystemSecurityRealm(this.root, this.nameRewriter, this.levels, this.encoded, this.hashEncoding, this.hashCharset, this.providers, this.secretKey);
    }
}

