/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static final ReflectionFactory reflectionFactory = System.getSecurityManager() == null ? ReflectionFactory.getReflectionFactory() : AccessController.doPrivileged(new PrivilegedAction<ReflectionFactory>(){

        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    });

    JDKSpecific() {
    }

    static Constructor<?> newConstructorForSerialization(Class<?> classToInstantiate, Constructor<?> constructorToCall) {
        return reflectionFactory.newConstructorForSerialization(classToInstantiate, constructorToCall);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class SerMethods {
        private final MethodHandle readObject;
        private final MethodHandle readObjectNoData;
        private final MethodHandle writeObject;
        private final MethodHandle readResolve;
        private final MethodHandle writeReplace;
        private final Constructor<?> noArgConstructor;
        private final Constructor<?> objectInputConstructor;

        SerMethods(Class<?> clazz) {
            Constructor<?> ctor;
            this.readObject = reflectionFactory.readObjectForSerialization(clazz);
            this.readObjectNoData = reflectionFactory.readObjectNoDataForSerialization(clazz);
            this.writeObject = reflectionFactory.writeObjectForSerialization(clazz);
            this.readResolve = reflectionFactory.readResolveForSerialization(clazz);
            this.writeReplace = reflectionFactory.writeReplaceForSerialization(clazz);
            Constructor<?> noArgConstructor = null;
            try {
                ctor = clazz.getDeclaredConstructor(new Class[0]);
                noArgConstructor = reflectionFactory.newConstructorForSerialization(clazz, ctor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.noArgConstructor = noArgConstructor;
            Constructor<?> objectInputConstructor = null;
            try {
                ctor = clazz.getDeclaredConstructor(ObjectInput.class);
                objectInputConstructor = reflectionFactory.newConstructorForSerialization(clazz, ctor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.objectInputConstructor = objectInputConstructor;
        }

        boolean hasWriteObject() {
            return this.writeObject != null;
        }

        void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
            try {
                this.writeObject.invoke(object, outputStream);
            }
            catch (IOException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasReadObject() {
            return this.readObject != null;
        }

        void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            try {
                this.readObject.invoke(object, inputStream);
            }
            catch (IOException | ClassNotFoundException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasReadObjectNoData() {
            return this.readObjectNoData != null;
        }

        void callReadObjectNoData(Object object) throws ObjectStreamException {
            try {
                this.readObjectNoData.invoke(object);
            }
            catch (ObjectStreamException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasWriteReplace() {
            return this.writeReplace != null;
        }

        Object callWriteReplace(Object object) throws ObjectStreamException {
            try {
                return this.writeReplace.invoke(object);
            }
            catch (ObjectStreamException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasReadResolve() {
            return this.readResolve != null;
        }

        Object callReadResolve(Object object) throws ObjectStreamException {
            try {
                return this.readResolve.invoke(object);
            }
            catch (ObjectStreamException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        Constructor<?> getNoArgConstructor() {
            return this.noArgConstructor;
        }

        Constructor<?> getObjectInputConstructor() {
            return this.objectInputConstructor;
        }
    }
}

