/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.ParticipantInboundEvents;
import com.arjuna.webservices11.wsat.client.CoordinatorClient;
import com.arjuna.webservices11.wsat.processors.ParticipantProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class ParticipantProcessorImpl
extends ParticipantProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateParticipant(ParticipantInboundEvents participant, String identifier) {
        this.activatedObjectProcessor.activateObject(participant, identifier);
    }

    @Override
    public void deactivateParticipant(ParticipantInboundEvents participant) {
        this.activatedObjectProcessor.deactivateObject(participant);
    }

    @Override
    public boolean isActive(String identifier) {
        return this.activatedObjectProcessor.getObject(identifier) != null;
    }

    private ParticipantInboundEvents getParticipant(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (ParticipantInboundEvents)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public void commit(Notification commit, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        XTSATRecoveryManager recoveryManager = XTSATRecoveryManager.getRecoveryManager();
        if (recoveryManager == null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_commit_3(instanceIdentifier.toString());
            return;
        }
        ParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.commit(commit, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_commit_1(th);
            }
        } else if (!recoveryManager.isParticipantRecoveryStarted()) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_commit_4(instanceIdentifier.toString());
        } else if (recoveryManager.findParticipantRecoveryRecord(instanceIdentifier.getInstanceIdentifier()) != null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_commit_5(instanceIdentifier.toString());
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_commit_2(instanceIdentifier.toString());
            this.sendCommitted(map, arjunaContext);
        }
    }

    @Override
    public void prepare(Notification prepare, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.prepare(prepare, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_prepare_1(th);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_prepare_2(instanceIdentifier.toString());
            this.sendAborted(map, arjunaContext);
        }
    }

    @Override
    public void rollback(Notification rollback, MAP map, ArjunaContext arjunaContext) {
        ParticipantInboundEvents participant;
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        XTSATRecoveryManager recoveryManager = XTSATRecoveryManager.getRecoveryManager();
        if (recoveryManager == null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_rollback_3(instanceIdentifier.toString());
        }
        if ((participant = this.getParticipant(instanceIdentifier)) != null) {
            try {
                participant.rollback(rollback, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_rollback_1(th);
            }
        } else if (!recoveryManager.isParticipantRecoveryStarted()) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_rollback_4(instanceIdentifier.toString());
        } else if (recoveryManager.findParticipantRecoveryRecord(instanceIdentifier.getInstanceIdentifier()) != null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_rollback_5(instanceIdentifier.toString());
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_rollback_2(instanceIdentifier.toString());
            this.sendAborted(map, arjunaContext);
        }
    }

    @Override
    public void soapFault(SoapFault fault, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.soapFault(fault, map, arjunaContext);
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_soapFault_1(th);
            }
        } else {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantProcessorImpl_soapFault_2(instanceIdentifier.toString());
        }
    }

    private void sendCommitted(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseMAP = AddressingHelper.createResponseContext(map, messageId);
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            try {
                CoordinatorClient.getClient().sendCommitted(null, responseMAP, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Committed", (Object)th);
            }
        }
    }

    private void sendAborted(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseMAP = AddressingHelper.createResponseContext(map, messageId);
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            try {
                CoordinatorClient.getClient().sendAborted(null, responseMAP, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Aborted", (Object)th);
            }
        }
    }
}

