/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class UniJoinFirst<T>
extends AbstractUni<T> {
    private final List<Uni<? extends T>> unis;
    private final Mode mode;

    public UniJoinFirst(List<Uni<? extends T>> unis, Mode mode) {
        this.unis = unis;
        this.mode = mode;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        UniJoinFirstSubscription joinAllSubscription = new UniJoinFirstSubscription(subscriber);
        subscriber.onSubscribe(joinAllSubscription);
        joinAllSubscription.triggerSubscriptions();
    }

    private class UniJoinFirstSubscription
    implements UniSubscription {
        private final UniSubscriber<? super T> subscriber;
        private final AtomicReferenceArray<UniSubscription> subscriptions;
        private final AtomicBoolean cancelled;
        private final List<Throwable> failures;

        public UniJoinFirstSubscription(UniSubscriber<? super T> subscriber) {
            this.subscriptions = new AtomicReferenceArray(UniJoinFirst.this.unis.size());
            this.cancelled = new AtomicBoolean();
            this.failures = Collections.synchronizedList(new ArrayList());
            this.subscriber = subscriber;
        }

        public void triggerSubscriptions() {
            for (int i = 0; i < UniJoinFirst.this.unis.size() && !this.cancelled.get(); ++i) {
                int index = i;
                Uni uni = (Uni)UniJoinFirst.this.unis.get(i);
                uni.onSubscription().invoke(subscription -> this.subscriptions.set(index, (UniSubscription)subscription)).subscribe().with(this::onItem, this::onFailure);
            }
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
            this.cancelSubscriptions();
        }

        private void cancelSubscriptions() {
            for (int i = 0; i < UniJoinFirst.this.unis.size(); ++i) {
                UniSubscription sub = this.subscriptions.get(i);
                if (sub == null) continue;
                sub.cancel();
            }
        }

        private void onItem(T item) {
            if (this.cancelled.compareAndSet(false, true)) {
                this.cancelSubscriptions();
                this.subscriber.onItem(item);
            }
        }

        private void onFailure(Throwable failure) {
            switch (UniJoinFirst.this.mode) {
                case FIRST_TO_EMIT: {
                    if (this.cancelled.compareAndSet(false, true)) {
                        this.cancelSubscriptions();
                        this.subscriber.onFailure(failure);
                        break;
                    }
                    Infrastructure.handleDroppedException(failure);
                    break;
                }
                case FIRST_WITH_ITEM: {
                    if (!this.cancelled.get()) {
                        this.failures.add(failure);
                        if (this.failures.size() != UniJoinFirst.this.unis.size()) break;
                        this.cancelled.set(true);
                        this.subscriber.onFailure(new CompositeException(this.failures));
                        break;
                    }
                    Infrastructure.handleDroppedException(failure);
                }
            }
        }
    }

    public static enum Mode {
        FIRST_TO_EMIT,
        FIRST_WITH_ITEM;

    }
}

