/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.Version;

public final class VersionDetection {
    private VersionDetection() {
    }

    public static Version detectVersion(ResourceLoader resourceLoader) throws IOException {
        Resource resource = resourceLoader.getResource("META-INF/MANIFEST.MF");
        if (resource != null) {
            Manifest manifest;
            try (InputStream is = resource.openStream();){
                manifest = new Manifest(is);
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String versionString = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (versionString != null) {
                try {
                    return Version.parse(versionString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

