/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jboss.resteasy.security.BouncyIntegration;

public class KeyTools {
    public static X509Certificate generateTestCertificate(KeyPair pair) {
        return KeyTools.generateV1SelfSignedCertificate(pair, "Test", null);
    }

    public static X509Certificate generateTestCertificate(String subject, String issuer, KeyPair pair) {
        return KeyTools.generateV1SelfSignedCertificate(pair, subject, issuer);
    }

    private static X509Certificate generateV1SelfSignedCertificate(KeyPair caKeyPair, String subject, String issuer) {
        try {
            X500Name subjectDN = new X500Name("CN=" + subject);
            X500Name issuerDN = issuer == null ? subjectDN : new X500Name("CN=" + issuer);
            Date validityStartDate = new Date(System.currentTimeMillis() - 10000L);
            Date validityEndDate = new Date(System.currentTimeMillis() + 10000L);
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)caKeyPair.getPublic().getEncoded());
            X509v1CertificateBuilder certGen = new X509v1CertificateBuilder(issuerDN, BigInteger.valueOf(System.currentTimeMillis()), validityStartDate, validityEndDate, subjectDN, subPubKeyInfo);
            X509CertificateHolder holder = certGen.build(KeyTools.createSigner(caKeyPair.getPrivate()));
            return new JcaX509CertificateConverter().getCertificate(holder);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating X509v1Certificate.", e);
        }
    }

    private static ContentSigner createSigner(PrivateKey privateKey) {
        try {
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WithRSAEncryption");
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            return new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(PrivateKeyFactory.createKey((byte[])privateKey.getEncoded()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create content signer.", e);
        }
    }

    static {
        BouncyIntegration.init();
    }
}

