/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.appclient.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.appclient.parser.spec.AppClientElement;
import org.jboss.metadata.appclient.parser.spec.ApplicationClientAttribute;
import org.jboss.metadata.appclient.spec.AppClientEnvironmentRefsGroupMetaData;
import org.jboss.metadata.appclient.spec.ApplicationClientMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.MessageDestinationMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

public class ApplicationClientMetaDataParser
extends MetaDataElementParser {
    public static final ApplicationClientMetaDataParser INSTANCE = new ApplicationClientMetaDataParser();

    public ApplicationClientMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return this.parse(reader, PropertyReplacers.noop());
    }

    public ApplicationClientMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
        ApplicationClientMetaData appClientMetadata = new ApplicationClientMetaData();
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (ApplicationClientMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            this.processAttribute(appClientMetadata, reader, i);
        }
        appClientMetadata.setDescriptionGroup(new DescriptionGroupMetaData());
        appClientMetadata.setEnvironmentRefsGroupMetaData(new AppClientEnvironmentRefsGroupMetaData());
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.processElement(appClientMetadata, reader, propertyReplacer);
        }
        return appClientMetadata;
    }

    protected void processAttribute(ApplicationClientMetaData metaData, XMLStreamReader reader, int i) throws XMLStreamException {
        String value = reader.getAttributeValue(i);
        ApplicationClientAttribute ejbJarAttribute = ApplicationClientAttribute.forName(reader.getAttributeLocalName(i));
        switch (ejbJarAttribute) {
            case ID: {
                metaData.setId(value);
                break;
            }
            case VERSION: {
                metaData.setVersion(value);
                break;
            }
            case METADATA_COMPLETE: {
                metaData.setMetadataComplete(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ApplicationClientMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
            }
        }
    }

    protected void processElement(ApplicationClientMetaData applicationClientMetaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)applicationClientMetaData.getDescriptionGroup())) {
            return;
        }
        AppClientEnvironmentRefsGroupMetaData env = applicationClientMetaData.getEnvironmentRefsGroupMetaData();
        if (EnvironmentRefsGroupMetaDataParser.parseRemote((XMLStreamReader)reader, (RemoteEnvironmentRefsGroupMetaData)env)) {
            return;
        }
        AppClientElement element = AppClientElement.forName(reader.getLocalName());
        switch (element) {
            case CALLBACK_HANDLER: {
                applicationClientMetaData.setCallbackHandler(ApplicationClientMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case MESSAGE_DESTINATION: {
                MessageDestinationsMetaData metaData = env.getMessageDestinations();
                if (metaData == null) {
                    metaData = new MessageDestinationsMetaData();
                    env.setMessageDestinations(metaData);
                }
                metaData.add((MappableMetaData)MessageDestinationMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case MODULE_NAME: {
                applicationClientMetaData.setModuleName(ApplicationClientMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            default: {
                throw ApplicationClientMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }
}

