/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.wildfly.clustering.marshalling.protostream.EnumMarshallerAdapter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerAdapter;

public class DefaultSerializationContext
implements SerializationContext,
Supplier<ImmutableSerializationContext> {
    private final SerializationContext context = new SerializationContextImpl(Configuration.builder().build());

    @Override
    public ImmutableSerializationContext get() {
        return this.context;
    }

    public Configuration getConfiguration() {
        return this.context.getConfiguration();
    }

    public Map<String, FileDescriptor> getFileDescriptors() {
        return this.context.getFileDescriptors();
    }

    public Map<String, GenericDescriptor> getGenericDescriptors() {
        return this.context.getGenericDescriptors();
    }

    public Descriptor getMessageDescriptor(String fullTypeName) {
        return this.context.getMessageDescriptor(fullTypeName);
    }

    public EnumDescriptor getEnumDescriptor(String fullTypeName) {
        return this.context.getEnumDescriptor(fullTypeName);
    }

    public boolean canMarshall(Class<?> javaClass) {
        return this.context.canMarshall(javaClass);
    }

    public boolean canMarshall(String fullTypeName) {
        return this.context.canMarshall(fullTypeName);
    }

    public boolean canMarshall(Object object) {
        return this.context.canMarshall(object);
    }

    public <T> BaseMarshaller<T> getMarshaller(T object) {
        return this.context.getMarshaller(object);
    }

    public <T> BaseMarshaller<T> getMarshaller(String fullTypeName) {
        return this.context.getMarshaller(fullTypeName);
    }

    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.context.getMarshaller(clazz);
    }

    @Deprecated
    public String getTypeNameById(Integer typeId) {
        return this.context.getTypeNameById(typeId);
    }

    @Deprecated
    public Integer getTypeIdByName(String fullTypeName) {
        return this.context.getTypeIdByName(fullTypeName);
    }

    public GenericDescriptor getDescriptorByTypeId(Integer typeId) {
        return this.context.getDescriptorByTypeId(typeId);
    }

    public GenericDescriptor getDescriptorByName(String fullTypeName) {
        return this.context.getDescriptorByName(fullTypeName);
    }

    public void registerProtoFiles(FileDescriptorSource source) throws DescriptorParserException {
        this.context.registerProtoFiles(source);
    }

    public void unregisterProtoFile(String fileName) {
        this.context.unregisterProtoFile(fileName);
    }

    public void unregisterProtoFiles(Set<String> fileNames) {
        this.context.unregisterProtoFiles(fileNames);
    }

    public void registerMarshaller(BaseMarshaller<?> marshaller) {
        this.context.registerMarshaller(this.adapt(marshaller));
    }

    public void unregisterMarshaller(BaseMarshaller<?> marshaller) {
        this.context.unregisterMarshaller(marshaller);
    }

    @Deprecated
    public void registerMarshallerProvider(SerializationContext.MarshallerProvider provider) {
        this.context.registerMarshallerProvider(this.adapt(provider));
    }

    @Deprecated
    public void unregisterMarshallerProvider(SerializationContext.MarshallerProvider provider) {
        this.context.unregisterMarshallerProvider(provider);
    }

    public void registerMarshallerProvider(SerializationContext.InstanceMarshallerProvider<?> provider) {
        this.context.registerMarshallerProvider(this.adapt(provider));
    }

    public void unregisterMarshallerProvider(SerializationContext.InstanceMarshallerProvider<?> provider) {
        this.context.unregisterMarshallerProvider(provider);
    }

    <T> BaseMarshaller<T> adapt(BaseMarshaller<T> marshaller) {
        if (marshaller instanceof ProtoStreamMarshaller) {
            return marshaller;
        }
        if (marshaller instanceof ProtobufTagMarshaller) {
            return new ProtoStreamMarshallerAdapter((ProtobufTagMarshaller)marshaller);
        }
        if (marshaller instanceof EnumMarshaller) {
            return new EnumMarshallerAdapter((EnumMarshaller)marshaller);
        }
        throw new IllegalArgumentException(marshaller.getTypeName());
    }

    private <T> SerializationContext.InstanceMarshallerProvider<T> adapt(final SerializationContext.InstanceMarshallerProvider<T> provider) {
        return new SerializationContext.InstanceMarshallerProvider<T>(){

            public Class<T> getJavaClass() {
                return provider.getJavaClass();
            }

            public Set<String> getTypeNames() {
                return provider.getTypeNames();
            }

            public String getTypeName(T instance) {
                return provider.getTypeName(instance);
            }

            public BaseMarshaller<T> getMarshaller(T instance) {
                BaseMarshaller marshaller = provider.getMarshaller(instance);
                return marshaller != null ? DefaultSerializationContext.this.adapt(marshaller) : null;
            }

            public BaseMarshaller<T> getMarshaller(String typeName) {
                BaseMarshaller marshaller = provider.getMarshaller(typeName);
                return marshaller != null ? DefaultSerializationContext.this.adapt(marshaller) : null;
            }
        };
    }

    @Deprecated
    private SerializationContext.MarshallerProvider adapt(final SerializationContext.MarshallerProvider provider) {
        return new SerializationContext.MarshallerProvider(){

            public BaseMarshaller<?> getMarshaller(String typeName) {
                BaseMarshaller marshaller = provider.getMarshaller(typeName);
                return marshaller != null ? DefaultSerializationContext.this.adapt(marshaller) : null;
            }

            public BaseMarshaller<?> getMarshaller(Class<?> javaClass) {
                BaseMarshaller marshaller = provider.getMarshaller(javaClass);
                return marshaller != null ? DefaultSerializationContext.this.adapt(marshaller) : null;
            }
        };
    }
}

