/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set((OpenTelemetry)sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        if (this.tracerProvider == null) {
            this.tracerProvider = SdkTracerProvider.builder().build();
        }
        return new OpenTelemetrySdk(new OpenTelemetrySdk.ObfuscatedTracerProvider(this.tracerProvider), this.propagators);
    }
}

