/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password.simple;

import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.domain.management.security.password.Dictionary;

public class SimpleDictionary
implements Dictionary {
    protected Set<String> words = new TreeSet<String>();

    public SimpleDictionary() {
        InputStream is = Dictionary.class.getResourceAsStream("dictionary.properties");
        if (is != null) {
            this.init(is);
        }
    }

    public SimpleDictionary(InputStream is) {
        this.init(is);
    }

    protected void init(InputStream is) {
        try {
            Properties props = new Properties();
            props.load(is);
            for (String string : props.keySet()) {
                this.words.add(string);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public int dictionarySequence(String password) {
        int count;
        String tmp;
        int index;
        if (password.length() == 0) {
            return 0;
        }
        if (this.words.contains(password)) {
            return password.length();
        }
        int higher = 0;
        for (index = 1; index < password.length(); ++index) {
            tmp = password.substring(index);
            count = this.dictionarySequence(tmp);
            if (count <= 0 || higher >= count) continue;
            higher = count;
        }
        for (index = password.length() - 1; 1 < index; --index) {
            tmp = password.substring(0, index);
            count = this.dictionarySequence(tmp);
            if (count <= 0 || higher >= count) continue;
            higher = count;
        }
        return higher;
    }
}

