/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.io.DataOutput;
import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.IpAddressUUID;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.group.IpAddressBuilder;
import org.wildfly.clustering.server.group.IpAddressMarshaller;

public class IpAddressUUIDMarshaller
implements ProtoStreamMarshaller<IpAddressUUID> {
    private static final long DEFAULT_LOW_BITS = 0L;
    private static final int DEFAULT_HIGH_BITS = 0;
    private static final int IP_ADDRESS_INDEX = 1;
    private static final int LOW_INDEX = 1 + IpAddressMarshaller.INSTANCE.getFields();
    private static final int HIGH_INDEX = LOW_INDEX + 1;

    public IpAddressUUID readFrom(ProtoStreamReader reader) throws IOException {
        IpAddressBuilder ipAddressBuilder = IpAddressMarshaller.INSTANCE.getBuilder();
        long low = 0L;
        int high = 0;
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index >= 1 && index < LOW_INDEX) {
                ipAddressBuilder = IpAddressMarshaller.INSTANCE.readField(reader, index - 1, ipAddressBuilder);
                continue;
            }
            if (index == LOW_INDEX) {
                low = reader.readSFixed64();
                continue;
            }
            if (index == HIGH_INDEX) {
                high = reader.readSFixed32();
                continue;
            }
            reader.skipField(tag);
        }
        return new DefaultIpAddressUUID((IpAddress)ipAddressBuilder.build(), low, high);
    }

    public void writeTo(ProtoStreamWriter writer, IpAddressUUID address) throws IOException {
        int high;
        IpAddressMarshaller.INSTANCE.writeFields(writer, 1, (IpAddress)address);
        UUIDCapturingDataOutput output = new UUIDCapturingDataOutput();
        address.writeTo((DataOutput)output);
        long low = output.getLow();
        if (low != 0L) {
            writer.writeSFixed64(LOW_INDEX, low);
        }
        if ((high = output.getHigh()) != 0) {
            writer.writeSFixed32(HIGH_INDEX, high);
        }
    }

    public Class<? extends IpAddressUUID> getJavaClass() {
        return IpAddressUUID.class;
    }

    static class UUIDCapturingDataOutput
    implements DataOutput {
        private long low;
        private int high;

        UUIDCapturingDataOutput() {
        }

        long getLow() {
            return this.low;
        }

        int getHigh() {
            return this.high;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.high = v;
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.low = v;
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
        }

        @Override
        public void writeByte(int v) throws IOException {
        }

        @Override
        public void writeShort(int v) throws IOException {
        }

        @Override
        public void writeChar(int v) throws IOException {
        }

        @Override
        public void writeFloat(float v) throws IOException {
        }

        @Override
        public void writeDouble(double v) throws IOException {
        }

        @Override
        public void writeBytes(String s) throws IOException {
        }

        @Override
        public void writeChars(String s) throws IOException {
        }

        @Override
        public void writeUTF(String s) throws IOException {
        }
    }

    private static class DefaultIpAddressUUID
    extends IpAddressUUID {
        DefaultIpAddressUUID(IpAddress ipAddress, long low, int high) {
            super(ipAddress.getIpAddress(), ipAddress.getPort(), low, high);
        }
    }
}

