/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.SubstringMap;
import io.undertow.util.URLUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class PathMatcher<T> {
    private static final String STRING_PATH_SEPARATOR = "/";
    private volatile T defaultHandler;
    private final SubstringMap<T> paths = new SubstringMap();
    private final ConcurrentMap<String, T> exactPathMatches = new CopyOnWriteMap<String, T>();
    private volatile int[] lengths = new int[0];

    public PathMatcher(T defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public PathMatcher() {
    }

    public Set<String> getExactPathMatchesSet() {
        return Collections.unmodifiableSet(this.exactPathMatches.keySet());
    }

    public Set<String> getPathMatchesSet() {
        return Collections.unmodifiableSet(this.paths.toMap().keySet());
    }

    public PathMatch<T> match(String path) {
        T match;
        if (!this.exactPathMatches.isEmpty() && (match = this.getExactPath(path)) != null) {
            UndertowLogger.REQUEST_LOGGER.debugf("Matched exact path %s", (Object)path);
            return new PathMatch<T>(path, "", match);
        }
        int length = path.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            SubstringMap.SubstringMatch<T> next;
            char c;
            int pathLength = lengths[i];
            if (pathLength == length) {
                SubstringMap.SubstringMatch<T> next2 = this.paths.get(path, length);
                if (next2 == null) continue;
                UndertowLogger.REQUEST_LOGGER.debugf("Matched prefix path %s for path %s", (Object)next2.getKey(), (Object)path);
                return new PathMatch<T>(path, "", next2.getValue());
            }
            if (pathLength >= length || (c = path.charAt(pathLength)) != '/' || (next = this.paths.get(path, pathLength)) == null) continue;
            UndertowLogger.REQUEST_LOGGER.debugf("Matched prefix path %s for path %s", (Object)next.getKey(), (Object)path);
            return new PathMatch<T>(next.getKey(), path.substring(pathLength), next.getValue());
        }
        UndertowLogger.REQUEST_LOGGER.debugf("Matched default handler path %s", (Object)path);
        return new PathMatch<T>("", path, this.defaultHandler);
    }

    public synchronized PathMatcher addPrefixPath(String path, T handler) {
        if (path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        String normalizedPath = URLUtils.normalizeSlashes(path);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath)) {
            this.defaultHandler = handler;
            return this;
        }
        this.paths.put(normalizedPath, handler);
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher addExactPath(String path, T handler) {
        if (path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        this.exactPathMatches.put(URLUtils.normalizeSlashes(path), handler);
        return this;
    }

    public T getExactPath(String path) {
        return (T)this.exactPathMatches.get(URLUtils.normalizeSlashes(path));
    }

    public T getPrefixPath(String path) {
        String normalizedPath = URLUtils.normalizeSlashes(path);
        SubstringMap.SubstringMatch<T> match = this.paths.get(normalizedPath);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath) && match == null) {
            return this.defaultHandler;
        }
        if (match == null) {
            return null;
        }
        return match.getValue();
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.paths.keys()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    @Deprecated
    public synchronized PathMatcher removePath(String path) {
        return this.removePrefixPath(path);
    }

    public synchronized PathMatcher removePrefixPath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        String normalizedPath = URLUtils.normalizeSlashes(path);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath)) {
            this.defaultHandler = null;
            return this;
        }
        this.paths.remove(normalizedPath);
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher removeExactPath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        this.exactPathMatches.remove(URLUtils.normalizeSlashes(path));
        return this;
    }

    public synchronized PathMatcher clearPaths() {
        this.paths.clear();
        this.exactPathMatches.clear();
        this.lengths = new int[0];
        this.defaultHandler = null;
        return this;
    }

    public Map<String, T> getPaths() {
        return this.paths.toMap();
    }

    public static final class PathMatch<T> {
        private final String matched;
        private final String remaining;
        private final T value;

        public PathMatch(String matched, String remaining, T value) {
            this.matched = matched;
            this.remaining = remaining;
            this.value = value;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String getMatched() {
            return this.matched;
        }

        public T getValue() {
            return this.value;
        }
    }
}

