/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.Collection;

public class JCommentPart
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;

    public JCommentPart append(Object o) {
        this.add(o);
        return this;
    }

    @Override
    public boolean add(Object o) {
        this.flattenAppend(o);
        return true;
    }

    private void flattenAppend(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.flattenAppend(o);
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.flattenAppend(o);
            }
        } else {
            super.add(value);
        }
    }

    protected void format(JFormatter f, String indent) {
        if (!f.isPrinting()) {
            for (Object o : this) {
                if (!(o instanceof JClass)) continue;
                f.g((JClass)o);
            }
            return;
        }
        if (!this.isEmpty()) {
            f.p(indent);
        }
        for (Object o : this) {
            if (o instanceof String) {
                int idx;
                String s = (String)o;
                while ((idx = s.indexOf(10)) != -1) {
                    String line = s.substring(0, idx);
                    if (line.length() > 0) {
                        f.p(this.escape(line));
                    }
                    s = s.substring(idx + 1);
                    f.nl().p(indent);
                }
                if (s.length() == 0) continue;
                f.p(this.escape(s));
                continue;
            }
            if (o instanceof JClass) {
                ((JClass)o).printLink(f);
                continue;
            }
            if (o instanceof JType) {
                f.g((JType)o);
                continue;
            }
            throw new IllegalStateException();
        }
        if (!this.isEmpty()) {
            f.nl();
        }
    }

    private String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '@': {
                    sb.append("&#064;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '*': {
                    sb.append(c);
                    if (s.charAt(i + 1) != '/') continue block7;
                    sb.append("<!---->");
                    sb.append('/');
                    ++i;
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

