/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.bv;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.Configuration;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jboss.jca.core.bv.JCATraversableResolver;
import org.jboss.jca.core.bv.SerializableValidator;
import org.jboss.jca.core.bv.SerializableValidatorFactory;

public class BeanValidation {
    private static final String VALIDATOR_FACTORY = "java:/ValidatorFactory";
    private static final String VALIDATOR = "java:/Validator";
    private ValidatorFactory validatorFactory;
    private Validator validator;

    public BeanValidation() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        Configuration conf = configuration.traversableResolver((TraversableResolver)new JCATraversableResolver());
        this.validatorFactory = conf.buildValidatorFactory();
        this.validator = this.validatorFactory.getValidator();
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void start() throws Throwable {
        InitialContext context = null;
        try {
            context = new InitialContext();
            context.rebind(VALIDATOR_FACTORY, (Object)new SerializableValidatorFactory(this.validatorFactory));
            context.rebind(VALIDATOR, (Object)new SerializableValidator(this.validator));
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }

    public void stop() throws Throwable {
        InitialContext context = null;
        try {
            context = new InitialContext();
            context.unbind(VALIDATOR);
            context.unbind(VALIDATOR_FACTORY);
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }
}

