/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultInitializeCollectionEventListener.class);

    @Override
    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection collection = event.getCollection();
        EventSource source = event.getSession();
        CollectionEntry ce = source.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!collection.wasInitialized()) {
            boolean foundInCache;
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Initializing collection {0}", MessageHelper.collectionInfoString(ce.getLoadedPersister(), collection, ce.getLoadedKey(), source));
                LOG.trace("Checking second-level cache");
            }
            if (foundInCache = this.initializeCollectionFromCache(ce.getLoadedKey(), ce.getLoadedPersister(), collection, source)) {
                if (traceEnabled) {
                    LOG.trace("Collection initialized from cache");
                }
            } else {
                if (traceEnabled) {
                    LOG.trace("Collection not cached");
                }
                ce.getLoadedPersister().initialize(ce.getLoadedKey(), source);
                if (traceEnabled) {
                    LOG.trace("Collection initialized");
                }
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatistics().fetchCollection(ce.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable id, CollectionPersister persister, PersistentCollection collection, SessionImplementor source) {
        boolean useCache;
        if (source.getLoadQueryInfluencers().hasEnabledFilters() && persister.isAffectedByEnabledFilters(source)) {
            LOG.trace("Disregarding cached version (if any) of collection due to enabled filters");
            return false;
        }
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        CollectionDataAccess cacheAccessStrategy = persister.getCacheAccessStrategy();
        Object ck = cacheAccessStrategy.generateCacheKey(id, persister, factory, source.getTenantIdentifier());
        Serializable ce = CacheHelper.fromSharedCache(source, ck, persister.getCacheAccessStrategy());
        if (factory.getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                factory.getStatistics().collectionCacheMiss(persister.getNavigableRole(), cacheAccessStrategy.getRegion().getName());
            } else {
                factory.getStatistics().collectionCacheHit(persister.getNavigableRole(), cacheAccessStrategy.getRegion().getName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        cacheEntry.assemble(collection, persister, persistenceContext.getCollectionOwner(id, persister));
        persistenceContext.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }
}

