/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ActiveMQExceptionMessage
extends PacketImpl {
    protected ActiveMQException exception;

    public ActiveMQExceptionMessage(ActiveMQException exception) {
        super((byte)20);
        this.exception = exception;
    }

    public ActiveMQExceptionMessage() {
        super((byte)20);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public ActiveMQException getException() {
        return this.exception;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.exception.getType().getCode());
        buffer.writeNullableString(this.exception.getMessage());
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        int code = buffer.readInt();
        String msg = buffer.readNullableString();
        this.exception = ActiveMQExceptionType.createException((int)code, (String)msg);
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", exception= " + (Object)((Object)this.exception);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exception == null ? 0 : ((Object)((Object)this.exception)).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ActiveMQExceptionMessage)) {
            return false;
        }
        ActiveMQExceptionMessage other = (ActiveMQExceptionMessage)obj;
        return !(this.exception == null ? other.exception != null : !((Object)((Object)this.exception)).equals((Object)other.exception));
    }
}

