/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyRemoveStepHandler;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.wildfly.extension.picketlink.common.model.ModelElement;

public abstract class AbstractResourceDefinition
extends SimpleResourceDefinition {
    private static final Map<ModelElement, List<SimpleAttributeDefinition>> attributeDefinitions = new HashMap<ModelElement, List<SimpleAttributeDefinition>>();
    private static final Map<ModelElement, List<ResourceDefinition>> childResourceDefinitions = new HashMap<ModelElement, List<ResourceDefinition>>();
    private final ModelElement modelElement;
    private final List<SimpleAttributeDefinition> attributes;

    protected AbstractResourceDefinition(ModelElement modelElement, OperationStepHandler addHandler, ResourceDescriptionResolver resourceDescriptor, SimpleAttributeDefinition ... attributes) {
        this(modelElement, PathElement.pathElement((String)modelElement.getName()), resourceDescriptor, addHandler, (OperationStepHandler)ModelOnlyRemoveStepHandler.INSTANCE, attributes);
    }

    protected AbstractResourceDefinition(ModelElement modelElement, OperationStepHandler addHandler, OperationStepHandler removeHandler, ResourceDescriptionResolver resourceDescriptor, SimpleAttributeDefinition ... attributes) {
        this(modelElement, PathElement.pathElement((String)modelElement.getName()), resourceDescriptor, addHandler, removeHandler, attributes);
    }

    protected AbstractResourceDefinition(ModelElement modelElement, String name, ModelOnlyAddStepHandler addHandler, ResourceDescriptionResolver resourceDescriptor, SimpleAttributeDefinition ... attributes) {
        this(modelElement, PathElement.pathElement((String)modelElement.getName(), (String)name), resourceDescriptor, (OperationStepHandler)addHandler, (OperationStepHandler)ModelOnlyRemoveStepHandler.INSTANCE, attributes);
    }

    private AbstractResourceDefinition(ModelElement modelElement, PathElement pathElement, ResourceDescriptionResolver resourceDescriptor, OperationStepHandler addHandler, OperationStepHandler removeHandler, SimpleAttributeDefinition ... attributes) {
        super(new SimpleResourceDefinition.Parameters(pathElement, resourceDescriptor).setAddHandler(addHandler).setRemoveHandler(removeHandler).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
        this.modelElement = modelElement;
        this.attributes = Collections.unmodifiableList(Arrays.asList(attributes));
    }

    public static List<SimpleAttributeDefinition> getAttributeDefinition(ModelElement modelElement) {
        List<SimpleAttributeDefinition> definitions = attributeDefinitions.get((Object)modelElement);
        if (definitions == null) {
            return Collections.emptyList();
        }
        return definitions;
    }

    public static Map<ModelElement, List<ResourceDefinition>> getChildResourceDefinitions() {
        return Collections.unmodifiableMap(childResourceDefinitions);
    }

    private void addAttributeDefinition(ModelElement resourceDefinitionKey, SimpleAttributeDefinition attribute) {
        List<SimpleAttributeDefinition> resourceAttributes = attributeDefinitions.get((Object)resourceDefinitionKey);
        if (resourceAttributes == null) {
            resourceAttributes = new ArrayList<SimpleAttributeDefinition>();
            attributeDefinitions.put(resourceDefinitionKey, resourceAttributes);
        }
        if (!resourceAttributes.contains(attribute)) {
            resourceAttributes.add(attribute);
        }
    }

    private void addChildResourceDefinition(ModelElement resourceDefinitionKey, ResourceDefinition resourceDefinition) {
        List<ResourceDefinition> childResources = childResourceDefinitions.get((Object)resourceDefinitionKey);
        if (childResources == null) {
            childResources = new ArrayList<ResourceDefinition>();
            childResourceDefinitions.put(resourceDefinitionKey, childResources);
        }
        if (!childResources.contains(resourceDefinition)) {
            for (ResourceDefinition childResource : childResources) {
                if (!childResource.getPathElement().getKey().equals(resourceDefinition.getPathElement().getKey())) continue;
                return;
            }
            childResources.add(resourceDefinition);
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        OperationStepHandler writeAttributeHandler = this.createAttributeWriterHandler();
        for (SimpleAttributeDefinition attribute : this.getAttributes()) {
            this.addAttributeDefinition(attribute, writeAttributeHandler, resourceRegistration);
        }
    }

    public List<SimpleAttributeDefinition> getAttributes() {
        return this.attributes;
    }

    private void addAttributeDefinition(SimpleAttributeDefinition definition, OperationStepHandler writeHandler, ManagementResourceRegistration resourceRegistration) {
        this.addAttributeDefinition(this.modelElement, definition);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)definition, null, writeHandler);
    }

    protected void addChildResourceDefinition(AbstractResourceDefinition definition, ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(this.modelElement, (ResourceDefinition)definition);
        resourceRegistration.registerSubModel((ResourceDefinition)definition);
    }

    protected OperationStepHandler createAttributeWriterHandler() {
        return new ModelOnlyWriteAttributeHandler(this.attributes.toArray(new AttributeDefinition[0]));
    }
}

