/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.Digest;
import org.wildfly.security.ssl.MechanismDatabase;

final class DigestCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<Digest> set;

    DigestCipherSuitePredicate(EnumSet<Digest> set) {
        this.set = set;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("digest is one of (");
        Iterator iterator = this.set.iterator();
        if (iterator.hasNext()) {
            Digest digest = (Digest)((Object)iterator.next());
            b.append((Object)digest);
            while (iterator.hasNext()) {
                digest = (Digest)((Object)iterator.next());
                b.append(", ");
                b.append((Object)digest);
            }
        }
        b.append(')');
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getDigest());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Digest.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

