/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.projectodd.vdx.core.ErrorType;
import org.projectodd.vdx.core.Position;

public class ValidationError {
    private final ErrorType type;
    private final Location location;
    private final String message;
    private String fallbackMessage = null;
    private QName element = null;
    private QName attribute = null;
    private String attributeValue = null;
    private final Set<String> alternatives = new HashSet<String>();

    public ValidationError(ErrorType type, String message, Location location) {
        this.type = type;
        this.location = location;
        this.message = message;
    }

    public static ValidationError from(XMLStreamException error, ErrorType type) {
        return new ValidationError(type, error.getMessage(), error.getLocation());
    }

    public static ValidationError from(ValidationError error, ErrorType type) {
        return new ValidationError(type, error.message(), error.location());
    }

    public ErrorType type() {
        return this.type;
    }

    public Location location() {
        return this.location;
    }

    public Position position() {
        return new Position(this.location.getLineNumber(), this.location.getColumnNumber());
    }

    public String message() {
        return this.message;
    }

    public String fallbackMessage() {
        return this.fallbackMessage;
    }

    public ValidationError fallbackMessage(String fallbackMessage) {
        this.fallbackMessage = fallbackMessage;
        return this;
    }

    public QName element() {
        return this.element;
    }

    public ValidationError element(QName element) {
        this.element = element;
        return this;
    }

    public QName attribute() {
        return this.attribute;
    }

    public ValidationError attribute(QName attribute) {
        this.attribute = attribute;
        return this;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    public ValidationError attributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        return this;
    }

    public Set<String> alternatives() {
        return this.alternatives;
    }

    public ValidationError alternatives(Set<String> alternatives) {
        this.alternatives.addAll(alternatives);
        return this;
    }
}

