/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.cache.sso.CompositeSSOManager;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactory<A, D, S>
implements SSOManagerFactory<A, D, S, TransactionBatch> {
    private final InfinispanSSOManagerFactoryConfiguration configuration;

    public InfinispanSSOManagerFactory(InfinispanSSOManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public <C, L> SSOManager<A, D, S, L, TransactionBatch> createSSOManager(SSOManagerConfiguration<C, L> configuration) {
        CoarseSessionsFactory sessionsFactory = new CoarseSessionsFactory(this.configuration);
        InfinispanSSOFactory factory = new InfinispanSSOFactory(this.configuration, new MarshalledValueMarshaller(configuration.getMarshalledValueFactory()), configuration.getLocalContextFactory(), sessionsFactory);
        AffinityIdentifierFactory idFactory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), this.configuration.getCache(), this.configuration.getKeyAffinityServiceFactory());
        return new CompositeSSOManager(factory, (IdentifierFactory)idFactory, this.configuration.getBatcher());
    }
}

