/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.logging;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.ConfigurationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import org.wildfly.iiop.openjdk.rmi.ir.IRConstructionException;

public class IIOPLogger_$logger
extends DelegatingBasicLogger
implements IIOPLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IIOPLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public IIOPLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void activatingSubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSubsystem$str(), new Object[0]);
    }

    protected String activatingSubsystem$str() {
        return "WFLYIIOP0001: Activating IIOP Subsystem";
    }

    @Override
    public final void failedToFetchCSIv2Policy(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToFetchCSIv2Policy$str(), new Object[0]);
    }

    protected String failedToFetchCSIv2Policy$str() {
        return "WFLYIIOP0002: Error fetching CSIv2Policy";
    }

    @Override
    public final void caughtExceptionEncodingGSSUPMechOID(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.caughtExceptionEncodingGSSUPMechOID$str(), new Object[0]);
    }

    protected String caughtExceptionEncodingGSSUPMechOID$str() {
        return "WFLYIIOP0003: Caught exception while encoding GSSUPMechOID";
    }

    @Override
    public final void logInternalError(Exception cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.logInternalError$str(), new Object[0]);
    }

    protected String logInternalError$str() {
        return "WFLYIIOP0004: Internal error";
    }

    @Override
    public final void failedToCreateNamingContext(Exception cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.failedToCreateNamingContext$str(), new Object[0]);
    }

    protected String failedToCreateNamingContext$str() {
        return "WFLYIIOP0005: Failed to create CORBA naming context";
    }

    @Override
    public final void failedToUnbindObject(Object name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToUnbindObject$str(), name);
    }

    protected String failedToUnbindObject$str() {
        return "WFLYIIOP0006: Unbind failed for %s";
    }

    @Override
    public final void failedToObtainJSSEDomain(String securityDomain) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToObtainJSSEDomain$str(), (Object)securityDomain);
    }

    protected String failedToObtainJSSEDomain$str() {
        return "WFLYIIOP0007: Failed to obtain JSSE security domain with name %s";
    }

    @Override
    public final void corbaNamingServiceStarted() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.corbaNamingServiceStarted$str(), new Object[0]);
    }

    protected String corbaNamingServiceStarted$str() {
        return "WFLYIIOP0008: CORBA Naming Service started";
    }

    @Override
    public final void corbaORBServiceStarted() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.corbaORBServiceStarted$str(), new Object[0]);
    }

    protected String corbaORBServiceStarted$str() {
        return "WFLYIIOP0009: CORBA ORB Service started";
    }

    @Override
    public final void warnClassDescDoesNotConformToSpec() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnClassDescDoesNotConformToSpec$str(), new Object[0]);
    }

    protected String warnClassDescDoesNotConformToSpec$str() {
        return "WFLYIIOP0010: Compatibility problem: Class javax.rmi.CORBA.ClassDesc does not conform to the Java(TM) Language to IDL Mapping Specification (01-06-07), section 1.3.5.11";
    }

    @Override
    public final void warnCouldNotDeactivateIRObject(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.warnCouldNotDeactivateIRObject$str(), new Object[0]);
    }

    protected String warnCouldNotDeactivateIRObject$str() {
        return "WFLYIIOP0011: Could not deactivate IR object";
    }

    @Override
    public final void warnCouldNotDeactivateAnonIRObject(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.warnCouldNotDeactivateAnonIRObject$str(), new Object[0]);
    }

    protected String warnCouldNotDeactivateAnonIRObject$str() {
        return "WFLYIIOP0012: Could not deactivate anonymous IR object";
    }

    protected String noSecurityDomainOrSSLContextsSpecified$str() {
        return "WFLYIIOP0013: SSL support has been enabled but no security domain or client/server SSL contexts have been specified";
    }

    @Override
    public final OperationFailedException noSecurityDomainOrSSLContextsSpecified() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSecurityDomainOrSSLContextsSpecified$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unexpectedException$str() {
        return "WFLYIIOP0014: Unexpected exception";
    }

    @Override
    public final RuntimeException unexpectedException(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unexpectedException$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedContextErrorInSASReply$str() {
        return "WFLYIIOP0015: Unexpected ContextError in SAS reply";
    }

    @Override
    public final NO_PERMISSION unexpectedContextErrorInSASReply(int minorCode, CompletionStatus status) {
        NO_PERMISSION result = new NO_PERMISSION(String.format(this.getLoggingLocale(), this.unexpectedContextErrorInSASReply$str(), new Object[0]), minorCode, status);
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorParsingSASReply$str() {
        return "WFLYIIOP0016: Could not parse SAS reply: %s";
    }

    @Override
    public final MARSHAL errorParsingSASReply(Exception e, int minorCode, CompletionStatus status) {
        MARSHAL result = new MARSHAL(String.format(this.getLoggingLocale(), this.errorParsingSASReply$str(), e), minorCode, status);
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRegisteringSASCurrentInitRef$str() {
        return "WFLYIIOP0017: Could not register initial reference for SASCurrent";
    }

    @Override
    public final RuntimeException errorRegisteringSASCurrentInitRef(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorRegisteringSASCurrentInitRef$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingSASContext$str() {
        return "WFLYIIOP0018: SAS context does not exist";
    }

    @Override
    public final NO_PERMISSION missingSASContext() {
        NO_PERMISSION result = new NO_PERMISSION(String.format(this.getLoggingLocale(), this.missingSASContext$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorDecodingInitContextToken$str() {
        return "WFLYIIOP0019: Could not decode initial context token";
    }

    @Override
    public final NO_PERMISSION errorDecodingInitContextToken() {
        NO_PERMISSION result = new NO_PERMISSION(String.format(this.getLoggingLocale(), this.errorDecodingInitContextToken$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorDecodingTargetInContextToken$str() {
        return "WFLYIIOP0020: Could not decode target name in initial context token";
    }

    @Override
    public final NO_PERMISSION errorDecodingTargetInContextToken() {
        NO_PERMISSION result = new NO_PERMISSION(String.format(this.getLoggingLocale(), this.errorDecodingTargetInContextToken$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorDecodingPrincipalName$str() {
        return "WFLYIIOP0021: Could not decode incoming principal name";
    }

    @Override
    public final NO_PERMISSION errorDecodingPrincipalName() {
        NO_PERMISSION result = new NO_PERMISSION(String.format(this.getLoggingLocale(), this.errorDecodingPrincipalName$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorDecodingContextData$str() {
        return "WFLYIIOP0022: Exception decoding context data in %s";
    }

    @Override
    public final RuntimeException errorDecodingContextData(String interceptorName, Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorDecodingContextData$str(), interceptorName), e);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalBatchSize$str() {
        return "WFLYIIOP0023: Batch size not numeric: %s";
    }

    @Override
    public final IllegalArgumentException illegalBatchSize(String batch) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalBatchSize$str(), batch));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorGettingBindingList$str() {
        return "WFLYIIOP0024: Error getting binding list";
    }

    @Override
    public final NamingException errorGettingBindingList() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.errorGettingBindingList$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorGeneratingObjectViaFactory$str() {
        return "WFLYIIOP0025: Error generating object via object factory";
    }

    @Override
    public final NamingException errorGeneratingObjectViaFactory() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.errorGeneratingObjectViaFactory$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorConstructingCNCtx$str() {
        return "WFLYIIOP0026: Error constructing context: either ORB or NamingContext must be supplied";
    }

    @Override
    public final ConfigurationException errorConstructingCNCtx() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.errorConstructingCNCtx$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notANamingContext$str() {
        return "WFLYIIOP0027: %s does not name a NamingContext";
    }

    @Override
    public final ConfigurationException notANamingContext(String name) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.notANamingContext$str(), name));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorConvertingIORToNamingCtx$str() {
        return "WFLYIIOP0028: Cannot convert IOR to NamingContext: %s";
    }

    @Override
    public final ConfigurationException errorConvertingIORToNamingCtx(String ior) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.errorConvertingIORToNamingCtx$str(), ior));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorResolvingNSInitRef$str() {
        return "WFLYIIOP0029: ORB.resolve_initial_references(\"NameService\") does not return a NamingContext";
    }

    @Override
    public final ConfigurationException errorResolvingNSInitRef() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.errorResolvingNSInitRef$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cosNamingNotRegisteredCorrectly$str() {
        return "WFLYIIOP0030: COS Name Service not registered with ORB under the name 'NameService'";
    }

    @Override
    public final NamingException cosNamingNotRegisteredCorrectly() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cosNamingNotRegisteredCorrectly$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorConnectingToORB$str() {
        return "WFLYIIOP0031: Cannot connect to ORB";
    }

    @Override
    public final NamingException errorConnectingToORB() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.errorConnectingToORB$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidURLOrIOR$str() {
        return "WFLYIIOP0032: Invalid IOR or URL: %s";
    }

    @Override
    public final NamingException invalidURLOrIOR(String ior) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.invalidURLOrIOR$str(), ior));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidObjectReference$str() {
        return "WFLYIIOP0033: Invalid object reference:  %s";
    }

    @Override
    public final NamingException invalidObjectReference(String ior) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.invalidObjectReference$str(), ior));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String urlDoesNotContainIOR$str() {
        return "WFLYIIOP0034: %s does not contain an IOR";
    }

    @Override
    public final ConfigurationException urlDoesNotContainIOR(String url) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.urlDoesNotContainIOR$str(), url));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notACorbaObject$str() {
        return "WFLYIIOP0035: Only instances of org.omg.CORBA.Object can be bound";
    }

    @Override
    public final IllegalArgumentException notACorbaObject() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notACorbaObject$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noReferenceFound$str() {
        return "WFLYIIOP0036: No object reference bound for specified name";
    }

    @Override
    public final NamingException noReferenceFound() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.noReferenceFound$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEmptyName$str() {
        return "WFLYIIOP0037: Invalid empty name";
    }

    @Override
    public final InvalidNameException invalidEmptyName() {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.invalidEmptyName$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unescapedCharacter$str() {
        return "WFLYIIOP0038: %s: unescaped \\ at end of component";
    }

    @Override
    public final InvalidNameException unescapedCharacter(String cnString) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.unescapedCharacter$str(), cnString));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEscapedCharacter$str() {
        return "WFLYIIOP0039: %s: Invalid character being escaped";
    }

    @Override
    public final InvalidNameException invalidEscapedCharacter(String cnString) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.invalidEscapedCharacter$str(), cnString));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidURL$str() {
        return "WFLYIIOP0040: Invalid %s URL: %s";
    }

    @Override
    public final MalformedURLException invalidURL(String protocol, String url) {
        MalformedURLException result = new MalformedURLException(String.format(this.getLoggingLocale(), this.invalidURL$str(), protocol, url));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String problemInvokingPortableRemoteObjectToStub$str() {
        return "WFLYIIOP0041: Problem with PortableRemoteObject.toStub(); object not exported or stub not found";
    }

    @Override
    public final ConfigurationException problemInvokingPortableRemoteObjectToStub() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.problemInvokingPortableRemoteObjectToStub$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInvokePortableRemoteObjectToStub$str() {
        return "WFLYIIOP0042: Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)";
    }

    @Override
    public final ConfigurationException cannotInvokePortableRemoteObjectToStub() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.cannotInvokePortableRemoteObjectToStub$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMethodDefForPortableRemoteObjectToStub$str() {
        return "WFLYIIOP0043: No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)";
    }

    @Override
    public final IllegalStateException noMethodDefForPortableRemoteObjectToStub() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noMethodDefForPortableRemoteObjectToStub$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String problemInvokingStubConnect$str() {
        return "WFLYIIOP0044: Problem invoking javax.rmi.CORBA.Stub.connect()";
    }

    @Override
    public final ConfigurationException problemInvokingStubConnect() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.problemInvokingStubConnect$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInvokeStubConnect$str() {
        return "WFLYIIOP0045: Cannot invoke javax.rmi.CORBA.Stub.connect()";
    }

    @Override
    public final ConfigurationException cannotInvokeStubConnect() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.cannotInvokeStubConnect$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMethodDefForStubConnect$str() {
        return "WFLYIIOP0046: No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)";
    }

    @Override
    public final IllegalStateException noMethodDefForStubConnect() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noMethodDefForStubConnect$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIIOPURLVersion$str() {
        return "WFLYIIOP0047: Invalid IIOP URL version: %s";
    }

    @Override
    public final MalformedURLException invalidIIOPURLVersion(String version) {
        MalformedURLException result = new MalformedURLException(String.format(this.getLoggingLocale(), this.invalidIIOPURLVersion$str(), version));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unavailableRMIPackages$str() {
        return "WFLYIIOP0048: javax.rmi packages not available";
    }

    @Override
    public final ConfigurationException unavailableRMIPackages() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.unavailableRMIPackages$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unavailableISOLatin1Decoder$str() {
        return "WFLYIIOP0049: ISO-Latin-1 decoder unavailable";
    }

    @Override
    public final MalformedURLException unavailableISOLatin1Decoder() {
        MalformedURLException result = new MalformedURLException(String.format(this.getLoggingLocale(), this.unavailableISOLatin1Decoder$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidURIEncoding$str() {
        return "WFLYIIOP0050: Invalid URI encoding: %s";
    }

    @Override
    public final MalformedURLException invalidURIEncoding(String encoding) {
        MalformedURLException result = new MalformedURLException(String.format(this.getLoggingLocale(), this.invalidURIEncoding$str(), encoding));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLookupJSSEDomain$str() {
        return "WFLYIIOP0051: Error configuring domain socket factory: failed to lookup JSSE security domain";
    }

    @Override
    public final ConfigurationException failedToLookupJSSEDomain() {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.failedToLookupJSSEDomain$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorObtainingKeyManagers$str() {
        return "WFLYIIOP0052: keyManager[] is null for security domain %s";
    }

    @Override
    public final IOException errorObtainingKeyManagers(String securityDomain) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.errorObtainingKeyManagers$str(), securityDomain));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToGetSSLContext$str() {
        return "WFLYIIOP0053: Failed to get SSL context";
    }

    @Override
    public final IOException failedToGetSSLContext(Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToGetSSLContext$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToStartJBossCOSNaming$str() {
        return "WFLYIIOP0054: Failed to start the JBoss Corba Naming Service";
    }

    @Override
    public final StartException failedToStartJBossCOSNaming(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartJBossCOSNaming$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String foreignTransaction$str() {
        return "WFLYIIOP0055: Foreign Transaction";
    }

    @Override
    public final UnsupportedOperationException foreignTransaction() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.foreignTransaction$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorEncodingContext$str() {
        return "WFLYIIOP0056: Exception raised during encoding";
    }

    @Override
    public final RuntimeException errorEncodingContext(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorEncodingContext$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorGettingSlotInTxInterceptor$str() {
        return "WFLYIIOP0057: Exception getting slot in TxServerInterceptor";
    }

    @Override
    public final RuntimeException errorGettingSlotInTxInterceptor(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorGettingSlotInTxInterceptor$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorSettingSlotInTxInterceptor$str() {
        return "WFLYIIOP0058: Exception setting slot in TxServerInterceptor";
    }

    @Override
    public final RuntimeException errorSettingSlotInTxInterceptor(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorSettingSlotInTxInterceptor$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAnalyzeNullClass$str() {
        return "WFLYIIOP0059: Cannot analyze a null class";
    }

    @Override
    public final IllegalArgumentException cannotAnalyzeNullClass() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotAnalyzeNullClass$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badConstantType$str() {
        return "WFLYIIOP0060: Bad type for a constant: %s";
    }

    @Override
    public final IllegalArgumentException badConstantType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.badConstantType$str(), type));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAnalyzeSpecialClass$str() {
        return "WFLYIIOP0061: Cannot analyze special class: %s";
    }

    @Override
    public final IllegalArgumentException cannotAnalyzeSpecialClass(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotAnalyzeSpecialClass$str(), type));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAnAccessor$str() {
        return "WFLYIIOP0062: Not an accessor: %s";
    }

    @Override
    public final IllegalArgumentException notAnAccessor(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAnAccessor$str(), name));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAnClassOrInterface$str() {
        return "WFLYIIOP0063: Not a class or interface: %s";
    }

    @Override
    public final IllegalArgumentException notAnClassOrInterface(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAnClassOrInterface$str(), name));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAnInterface$str() {
        return "WFLYIIOP0064: Class %s is not an interface";
    }

    @Override
    public final IllegalArgumentException notAnInterface(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAnInterface$str(), name));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAPrimitive$str() {
        return "WFLYIIOP0065: Not a primitive type: %s";
    }

    @Override
    public final IllegalArgumentException notAPrimitive(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAPrimitive$str(), type));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badRMIIIOPConstantType$str() {
        return "WFLYIIOP0066: Field %s of interface %s is a constant, but it is not primitive or String";
    }

    @Override
    public final RMIIIOPViolationException badRMIIIOPConstantType(String field, String intface, String section) {
        RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(this.getLoggingLocale(), this.badRMIIIOPConstantType$str(), field, intface), section);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badRMIIIOPExceptionType$str() {
        return "WFLYIIOP0067: Exception type %s must be a checked exception class";
    }

    @Override
    public final RMIIIOPViolationException badRMIIIOPExceptionType(String type, String section) {
        RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(this.getLoggingLocale(), this.badRMIIIOPExceptionType$str(), type), section);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badRMIIIOPMethodSignature$str() {
        return "WFLYIIOP0068: All interface methods must throw javax.rmi.RemoteException but method %s of interface %s does not";
    }

    @Override
    public final RMIIIOPViolationException badRMIIIOPMethodSignature(String method, String intface, String section) {
        RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(this.getLoggingLocale(), this.badRMIIIOPMethodSignature$str(), method, intface), section);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameCannotBeNullEmptyOrQualified$str() {
        return "WFLYIIOP0069: Name cannot be null, empty or qualified";
    }

    @Override
    public final IllegalArgumentException nameCannotBeNullEmptyOrQualified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nameCannotBeNullEmptyOrQualified$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String primitivesHaveNoIRIds$str() {
        return "WFLYIIOP0070: Primitive types have no IR IDs";
    }

    @Override
    public final IllegalArgumentException primitivesHaveNoIRIds() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.primitivesHaveNoIRIds$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unavailableSHADigest$str() {
        return "WFLYIIOP0071: No SHA message digest available";
    }

    @Override
    public final RuntimeException unavailableSHADigest(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unavailableSHADigest$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownPrimitiveType$str() {
        return "WFLYIIOP0072: Unknown primitive type: %s";
    }

    @Override
    public final RuntimeException unknownPrimitiveType(String type) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownPrimitiveType$str(), type));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAnalyzeStringType$str() {
        return "WFLYIIOP0073: Cannot analyze java.lang.String: it is a special case";
    }

    @Override
    public final IllegalArgumentException cannotAnalyzeStringType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotAnalyzeStringType$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAnalyzeClassType$str() {
        return "WFLYIIOP0074: Cannot analyze java.lang.Class: it is a special case";
    }

    @Override
    public final IllegalArgumentException cannotAnalyzeClassType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotAnalyzeClassType$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String valueTypeCantImplementRemote$str() {
        return "WFLYIIOP0075: Value type %s cannot implement java.rmi.Remote";
    }

    @Override
    public final RMIIIOPViolationException valueTypeCantImplementRemote(String type, String section) {
        RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(this.getLoggingLocale(), this.valueTypeCantImplementRemote$str(), type), section);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String valueTypeCantBeProxy$str() {
        return "WFLYIIOP0076: Value type %s cannot be a proxy or inner class";
    }

    @Override
    public final RMIIIOPViolationException valueTypeCantBeProxy(String type) {
        RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(this.getLoggingLocale(), this.valueTypeCantBeProxy$str(), type));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorLoadingClass$str() {
        return "WFLYIIOP0077: Error loading class %s";
    }

    @Override
    public final RuntimeException errorLoadingClass(String type, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorLoadingClass$str(), type), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noReadMethodInHelper$str() {
        return "WFLYIIOP0078: No read method in helper class %s";
    }

    @Override
    public final RuntimeException noReadMethodInHelper(String type, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.noReadMethodInHelper$str(), type), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noWriteMethodInHelper$str() {
        return "WFLYIIOP0079: No write method in helper class %s";
    }

    @Override
    public final RuntimeException noWriteMethodInHelper(String type, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.noWriteMethodInHelper$str(), type), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorUnmarshaling$str() {
        return "WFLYIIOP0080: Error unmarshaling %s";
    }

    @Override
    public final RuntimeException errorUnmarshaling(Class<?> type, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorUnmarshaling$str(), type), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorMarshaling$str() {
        return "WFLYIIOP0081: Error marshaling %s";
    }

    @Override
    public final RuntimeException errorMarshaling(Class<?> type, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorMarshaling$str(), type), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotObtainExceptionRepositoryID$str() {
        return "WFLYIIOP0082: Cannot obtain exception repository id for %s";
    }

    @Override
    public final RuntimeException cannotObtainExceptionRepositoryID(String type, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotObtainExceptionRepositoryID$str(), type), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorMashalingParams$str() {
        return "WFLYIIOP0083: Cannot marshal parameter: unexpected number of parameters";
    }

    @Override
    public final RuntimeException errorMashalingParams() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorMashalingParams$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotChangeRMIIIOPMapping$str() {
        return "WFLYIIOP0084: Cannot change RMI/IIOP mapping";
    }

    @Override
    public final BAD_INV_ORDER cannotChangeRMIIIOPMapping() {
        BAD_INV_ORDER result = new BAD_INV_ORDER(String.format(this.getLoggingLocale(), this.cannotChangeRMIIIOPMapping$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String badKindForTypeCode$str() {
        return "WFLYIIOP0085: Bad kind %d for TypeCode";
    }

    @Override
    public final RuntimeException badKindForTypeCode(int kind) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.badKindForTypeCode$str(), kind));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongInterfaceRepository$str() {
        return "WFLYIIOP0086: Wrong interface repository";
    }

    @Override
    public final IRConstructionException wrongInterfaceRepository() {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.wrongInterfaceRepository$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateRepositoryName$str() {
        return "WFLYIIOP0087: Duplicate repository name";
    }

    @Override
    public final IRConstructionException duplicateRepositoryName() {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.duplicateRepositoryName$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNullClass$str() {
        return "WFLYIIOP0088: Invalid null class";
    }

    @Override
    public final IllegalArgumentException invalidNullClass() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullClass$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badClassForConstant$str() {
        return "WFLYIIOP0089: Bad class %s for a constant";
    }

    @Override
    public final IRConstructionException badClassForConstant(String className) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.badClassForConstant$str(), className));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownTypeCodeForClass$str() {
        return "WFLYIIOP0090: TypeCode for class %s is unknown";
    }

    @Override
    public final IRConstructionException unknownTypeCodeForClass(String className) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.unknownTypeCodeForClass$str(), className));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateTypeCodeForClass$str() {
        return "WFLYIIOP0091: TypeCode for class %s already established";
    }

    @Override
    public final IRConstructionException duplicateTypeCodeForClass(String className) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.duplicateTypeCodeForClass$str(), className));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String collisionWhileCreatingPackage$str() {
        return "WFLYIIOP0092: Name collision while creating package";
    }

    @Override
    public final IRConstructionException collisionWhileCreatingPackage() {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.collisionWhileCreatingPackage$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classIsNotArray$str() {
        return "WFLYIIOP0093: Class %s is not an array class";
    }

    @Override
    public final IRConstructionException classIsNotArray(String className) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.classIsNotArray$str(), className));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotDestroyRMIIIOPMapping$str() {
        return "WFLYIIOP0094: Cannot destroy RMI/IIOP mapping";
    }

    @Override
    public final BAD_INV_ORDER cannotDestroyRMIIIOPMapping() {
        BAD_INV_ORDER result = new BAD_INV_ORDER(String.format(this.getLoggingLocale(), this.cannotDestroyRMIIIOPMapping$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String badKindForSuperValueType$str() {
        return "WFLYIIOP0095: Bad kind for super valuetype of %s";
    }

    @Override
    public final IRConstructionException badKindForSuperValueType(String id) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.badKindForSuperValueType$str(), id));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorResolvingRefToImplementedInterface$str() {
        return "WFLYIIOP0096: ValueDef %s unable to resolve reference to implemented interface %s";
    }

    @Override
    public final IRConstructionException errorResolvingRefToImplementedInterface(String id, String intface) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.errorResolvingRefToImplementedInterface$str(), id, intface));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorResolvingRefToAbstractValuetype$str() {
        return "WFLYIIOP0097: ValueDef %s unable to resolve reference to abstract base valuetype %s";
    }

    @Override
    public final IRConstructionException errorResolvingRefToAbstractValuetype(String id, String valuetype) {
        IRConstructionException result = new IRConstructionException(String.format(this.getLoggingLocale(), this.errorResolvingRefToAbstractValuetype$str(), id, valuetype));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorResolvingInitRef$str() {
        return "WFLYIIOP0098: Failed to resolve initial reference %s";
    }

    @Override
    public final StartException errorResolvingInitRef(String refName, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.errorResolvingInitRef$str(), refName), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorCreatingPOAFromParent$str() {
        return "WFLYIIOP0099: Failed to create POA from parent";
    }

    @Override
    public final StartException errorCreatingPOAFromParent(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.errorCreatingPOAFromParent$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidPOACreationArgs$str() {
        return "WFLYIIOP0100: Unable to instantiate POA: either the running ORB or the parent POA must be specified";
    }

    @Override
    public final StartException invalidPOACreationArgs() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPOACreationArgs$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorActivatingPOA$str() {
        return "WFLYIIOP0101: Failed to activate POA";
    }

    @Override
    public final StartException errorActivatingPOA(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.errorActivatingPOA$str(), new Object[0]), cause);
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String exceptionDestroingIterator$str() {
        return "WFLYIIOP0102: Caught exception destroying Iterator %s";
    }

    @Override
    public final INTERNAL exceptionDestroingIterator(String cause) {
        INTERNAL result = new INTERNAL(String.format(this.getLoggingLocale(), this.exceptionDestroingIterator$str(), cause));
        IIOPLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sslNotConfigured$str() {
        return "WFLYIIOP0103: IOR settings imply ssl connections usage, but secure connections have not been configured";
    }

    @Override
    public final OperationFailedException sslNotConfigured() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.sslNotConfigured$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentSupportedTransportConfig$str() {
        return "WFLYIIOP0104: Inconsistent transport-config configuration: %s is supported, please configure it to %s value";
    }

    @Override
    public final String inconsistentSupportedTransportConfig(String transportAttributeName, String suggested) {
        return String.format(this.getLoggingLocale(), this.inconsistentSupportedTransportConfig$str(), transportAttributeName, suggested);
    }

    protected String inconsistentUnsupportedTransportConfig$str() {
        return "WFLYIIOP0105: Inconsistent transport-config configuration: %s is not supported, please remove it or configure it to none value";
    }

    @Override
    public final String inconsistentUnsupportedTransportConfig(String transportAttributeName) {
        return String.format(this.getLoggingLocale(), this.inconsistentUnsupportedTransportConfig$str(), transportAttributeName);
    }

    protected String inconsistentRequiredTransportConfig$str() {
        return "WFLYIIOP0106: Inconsistent transport-config configuration: %s is set to true, please configure %s as required";
    }

    @Override
    public final String inconsistentRequiredTransportConfig(String requiredAttributeName, String transportAttributeName) {
        return String.format(this.getLoggingLocale(), this.inconsistentRequiredTransportConfig$str(), requiredAttributeName, transportAttributeName);
    }

    @Override
    public final void cannotCreateSSLSocket() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotCreateSSLSocket$str(), new Object[0]);
    }

    protected String cannotCreateSSLSocket$str() {
        return "WFLYIIOP0109: SSL socket is required by server but secure connections have not been configured";
    }

    protected String serverDoesNotSupportSsl$str() {
        return "WFLYIIOP0110: Client requires SSL but server does not support it";
    }

    @Override
    public final IllegalStateException serverDoesNotSupportSsl() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverDoesNotSupportSsl$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sslPortWithoutSslConfiguration$str() {
        return "WFLYIIOP0111: SSL has not been configured but ssl-port property has been specified - the connection will use clear-text protocol";
    }

    @Override
    public final String sslPortWithoutSslConfiguration() {
        return String.format(this.getLoggingLocale(), this.sslPortWithoutSslConfiguration$str(), new Object[0]);
    }

    protected String ineffectiveAuthenticationContextConfiguration$str() {
        return "WFLYIIOP0113: Authentication context has been defined but it is ineffective because the security initializer is not set to 'elytron'";
    }

    @Override
    public final OperationFailedException ineffectiveAuthenticationContextConfiguration() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.ineffectiveAuthenticationContextConfiguration$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elytronInitializerNotSupportedInPreviousVersions$str() {
        return "WFLYIIOP0114: Elytron security initializer not supported in previous iiop-openjdk versions and can't be converted";
    }

    @Override
    public final String elytronInitializerNotSupportedInPreviousVersions() {
        return String.format(this.getLoggingLocale(), this.elytronInitializerNotSupportedInPreviousVersions$str(), new Object[0]);
    }

    protected String noSocketBindingsConfigured$str() {
        return "WFLYIIOP0115: No IIOP socket bindings have been configured";
    }

    @Override
    public final IllegalStateException noSocketBindingsConfigured() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSocketBindingsConfigured$str(), new Object[0]));
        IIOPLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void wontUseCleartextSocket() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.wontUseCleartextSocket$str(), new Object[0]);
    }

    protected String wontUseCleartextSocket$str() {
        return "WFLYIIOP0117: CLEARTEXT in IIOP subsystem won't be used because server-requires-ssl parameter have been set to true";
    }
}

