/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.AbstractClassResolver;

public class ContextClassResolver
extends AbstractClassResolver {
    private static final PrivilegedAction<ClassLoader> GET_TCCL_ACTION = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public ContextClassResolver() {
    }

    public ContextClassResolver(boolean enforceSerialVersionUid) {
        super(enforceSerialVersionUid);
    }

    @Override
    protected ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GET_TCCL_ACTION);
    }
}

