/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.stream.ModelEvent;
import org.jboss.dmr.stream.ModelException;
import org.jboss.dmr.stream.ModelGrammarAnalyzer;
import org.jboss.dmr.stream.ModelReader;
import org.jboss.dmr.stream.Utils;

final class ModelReaderImpl
implements ModelReader {
    private static final char[] BIG = "big".toCharArray();
    private static final char[] BYTES = "bytes".toCharArray();
    private static final char[] DECIMAL = "decimal".toCharArray();
    private static final char[] EXPRESSION = "expression".toCharArray();
    private static final char[] FALSE = "false".toCharArray();
    private static final char[] INFINITY = "Infinity".toCharArray();
    private static final char[] INTEGER = "integer".toCharArray();
    private static final char[] NAN = "NaN".toCharArray();
    private static final char[] TRUE = "true".toCharArray();
    private static final char[] TYPE_BIG_DECIMAL = ModelType.BIG_DECIMAL.toString().toCharArray();
    private static final char[] TYPE_BIG_INTEGER = ModelType.BIG_INTEGER.toString().toCharArray();
    private static final char[] TYPE_BOOLEAN = ModelType.BOOLEAN.toString().toCharArray();
    private static final char[] TYPE_BYTES = ModelType.BYTES.toString().toCharArray();
    private static final char[] TYPE_DOUBLE = ModelType.DOUBLE.toString().toCharArray();
    private static final char[] TYPE_INT = ModelType.INT.toString().toCharArray();
    private static final char[] TYPE_LIST = ModelType.LIST.toString().toCharArray();
    private static final char[] TYPE_LONG = ModelType.LONG.toString().toCharArray();
    private static final char[] TYPE_EXPRESSION = ModelType.EXPRESSION.toString().toCharArray();
    private static final char[] TYPE_OBJECT = ModelType.OBJECT.toString().toCharArray();
    private static final char[] TYPE_PROPERTY = ModelType.PROPERTY.toString().toCharArray();
    private static final char[] TYPE_STRING = ModelType.STRING.toString().toCharArray();
    private static final char[] TYPE_TYPE = ModelType.TYPE.toString().toCharArray();
    private static final char[] TYPE_UNDEFINED = ModelType.UNDEFINED.toString().toCharArray();
    private static final char[] UNDEFINED = "undefined".toCharArray();
    private final Reader in;
    private final ModelGrammarAnalyzer analyzer;
    private char[] buffer = new char[1024];
    private int position;
    private int limit;
    private int numberOffset;
    private int numberLength;
    private int stringOffset;
    private int stringLength;
    private byte[] bytesValue;
    private ModelType typeValue;
    private int intValue;
    private long longValue;
    private double doubleValue;
    private BigInteger bigIntegerValue;
    private BigDecimal bigDecimalValue;
    private boolean booleanValue;
    private String stringValue;
    private boolean closed;

    ModelReaderImpl(Reader in) {
        this.in = in;
        this.analyzer = new ModelGrammarAnalyzer();
    }

    @Override
    public void close() throws ModelException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.analyzer.finished) {
            throw this.analyzer.newModelException("Uncomplete DMR stream have been read");
        }
    }

    @Override
    public String getString() {
        if (!this.isCurrentEvent(ModelEvent.STRING)) {
            throw new IllegalStateException("Current event isn't string");
        }
        return this.stringValue;
    }

    @Override
    public int getInt() {
        if (!this.isCurrentEvent(ModelEvent.INT)) {
            throw new IllegalStateException("Current event isn't int");
        }
        return this.intValue;
    }

    @Override
    public long getLong() {
        if (!this.isCurrentEvent(ModelEvent.LONG)) {
            throw new IllegalStateException("Current event isn't long");
        }
        return this.longValue;
    }

    @Override
    public double getDouble() {
        if (!this.isCurrentEvent(ModelEvent.DOUBLE)) {
            throw new IllegalStateException("Current event isn't double");
        }
        return this.doubleValue;
    }

    @Override
    public BigInteger getBigInteger() {
        if (!this.isCurrentEvent(ModelEvent.BIG_INTEGER)) {
            throw new IllegalStateException("Current event isn't big integer");
        }
        return this.bigIntegerValue;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (!this.isCurrentEvent(ModelEvent.BIG_DECIMAL)) {
            throw new IllegalStateException("Current event isn't big decimal");
        }
        return this.bigDecimalValue;
    }

    @Override
    public byte[] getBytes() {
        if (!this.isCurrentEvent(ModelEvent.BYTES)) {
            throw new IllegalStateException("Current event isn't bytes");
        }
        return this.bytesValue;
    }

    @Override
    public String getExpression() {
        if (!this.isCurrentEvent(ModelEvent.EXPRESSION)) {
            throw new IllegalStateException("Current event isn't expression");
        }
        return this.stringValue;
    }

    @Override
    public ModelType getType() {
        if (!this.isCurrentEvent(ModelEvent.TYPE)) {
            throw new IllegalStateException("Current event isn't type");
        }
        return this.typeValue;
    }

    @Override
    public boolean getBoolean() {
        if (!this.isCurrentEvent(ModelEvent.BOOLEAN)) {
            throw new IllegalStateException("Current event isn't boolean");
        }
        return this.booleanValue;
    }

    @Override
    public boolean isListEnd() {
        return this.isCurrentEvent(ModelEvent.LIST_END);
    }

    @Override
    public boolean isListStart() {
        return this.isCurrentEvent(ModelEvent.LIST_START);
    }

    @Override
    public boolean isObjectEnd() {
        return this.isCurrentEvent(ModelEvent.OBJECT_END);
    }

    @Override
    public boolean isObjectStart() {
        return this.isCurrentEvent(ModelEvent.OBJECT_START);
    }

    @Override
    public boolean isPropertyEnd() {
        return this.isCurrentEvent(ModelEvent.PROPERTY_END);
    }

    @Override
    public boolean isPropertyStart() {
        return this.isCurrentEvent(ModelEvent.PROPERTY_START);
    }

    @Override
    public boolean isString() {
        return this.isCurrentEvent(ModelEvent.STRING);
    }

    @Override
    public boolean isInt() {
        return this.isCurrentEvent(ModelEvent.INT);
    }

    @Override
    public boolean isLong() {
        return this.isCurrentEvent(ModelEvent.LONG);
    }

    @Override
    public boolean isDouble() {
        return this.isCurrentEvent(ModelEvent.DOUBLE);
    }

    @Override
    public boolean isBigInteger() {
        return this.isCurrentEvent(ModelEvent.BIG_INTEGER);
    }

    @Override
    public boolean isBigDecimal() {
        return this.isCurrentEvent(ModelEvent.BIG_DECIMAL);
    }

    @Override
    public boolean isBytes() {
        return this.isCurrentEvent(ModelEvent.BYTES);
    }

    @Override
    public boolean isExpression() {
        return this.isCurrentEvent(ModelEvent.EXPRESSION);
    }

    @Override
    public boolean isType() {
        return this.isCurrentEvent(ModelEvent.TYPE);
    }

    @Override
    public boolean isBoolean() {
        return this.isCurrentEvent(ModelEvent.BOOLEAN);
    }

    @Override
    public boolean isUndefined() {
        return this.isCurrentEvent(ModelEvent.UNDEFINED);
    }

    private boolean isCurrentEvent(ModelEvent event) {
        this.ensureOpen();
        return this.analyzer.currentEvent == event;
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        return !this.analyzer.finished;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ModelEvent next() throws IOException, ModelException {
        this.ensureOpen();
        if (this.analyzer.finished) {
            throw new IllegalStateException("No more DMR tokens available");
        }
        boolean assertEmptyStream = true;
        try {
            block67: while (true) {
                this.ensureBufferAccess(1);
                int currentChar = this.buffer[this.position++];
                switch (currentChar) {
                    case 34: {
                        this.analyzer.putString();
                        this.readString();
                        this.stringValue = new String(this.buffer, this.stringOffset, this.stringLength);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 61: {
                        this.ensureBufferAccess(1);
                        currentChar = this.buffer[this.position++];
                        if (currentChar != 62) {
                            throw this.newModelException("Unexpected character '" + (char)currentChar + "' while reading DMR arrow");
                        }
                        this.analyzer.putArrow();
                        continue block67;
                    }
                    case 44: {
                        this.analyzer.putComma();
                        continue block67;
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        boolean hexNumber = false;
                        if (currentChar == 43 || currentChar == 45) {
                            --this.position;
                            this.ensureBufferAccess(2);
                            ++this.position;
                            if (this.buffer[this.position] == 'I') {
                                this.readString(INFINITY);
                                this.analyzer.putNumber(ModelEvent.DOUBLE);
                                this.doubleValue = currentChar == 43 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                                ModelEvent modelEvent = this.analyzer.currentEvent;
                                return modelEvent;
                            }
                            if (this.buffer[this.position] == 'N') {
                                this.readString(NAN);
                                this.analyzer.putNumber(ModelEvent.DOUBLE);
                                this.doubleValue = Double.NaN;
                                ModelEvent modelEvent = this.analyzer.currentEvent;
                                return modelEvent;
                            }
                            if (!Utils.isNumberChar(this.buffer[this.position])) {
                                throw this.newModelException("Unexpected first character '" + this.buffer[this.position] + "' while reading DMR Infinity or NaN or number token");
                            }
                        }
                        if (currentChar == 48) {
                            --this.position;
                            if (this.ensureBufferAccessNoFail(2) && this.buffer[this.position + 1] == 'x') {
                                hexNumber = true;
                                ++this.position;
                            }
                            ++this.position;
                        }
                        if (!hexNumber) {
                            --this.position;
                        }
                        this.readNumber(hexNumber);
                        int n = currentChar = this.position < this.limit ? this.buffer[this.position++] : this.read();
                        if (currentChar == 76) {
                            try {
                                this.analyzer.putNumber(ModelEvent.LONG);
                                if (hexNumber) {
                                    this.longValue = this.parseHexLong();
                                }
                                this.longValue = Long.parseLong(new String(this.buffer, this.numberOffset, this.numberLength), 10);
                            }
                            catch (NumberFormatException nfe) {
                                throw this.newModelException("Incorrect long value", nfe);
                            }
                        } else {
                            if (currentChar != -1) {
                                --this.position;
                            }
                            if (this.isDecimalString()) {
                                try {
                                    this.analyzer.putNumber(ModelEvent.DOUBLE);
                                    this.doubleValue = Double.parseDouble(new String(this.buffer, this.numberOffset, this.numberLength));
                                }
                                catch (NumberFormatException nfe) {
                                    throw this.newModelException("Incorrect double value", nfe);
                                }
                            }
                            try {
                                this.analyzer.putNumber(ModelEvent.INT);
                                this.intValue = hexNumber ? this.parseHexInt() : Integer.parseInt(new String(this.buffer, this.numberOffset, this.numberLength), 10);
                            }
                            catch (NumberFormatException nfe) {
                                throw this.newModelException("Incorrect integer value", nfe);
                            }
                        }
                        ModelEvent nfe = this.analyzer.currentEvent;
                        return nfe;
                    }
                    case 98: {
                        --this.position;
                        this.ensureBufferAccess(2);
                        if (this.buffer[this.position + 1] == 'i') {
                            this.readString(BIG);
                            this.processWhitespaces();
                            this.ensureBufferAccess(1);
                            if (this.buffer[this.position] == 'd') {
                                this.readString(DECIMAL);
                                this.processWhitespaces();
                                this.readNumber(false);
                                try {
                                    this.analyzer.putNumber(ModelEvent.BIG_DECIMAL);
                                    this.bigDecimalValue = new BigDecimal(new String(this.buffer, this.numberOffset, this.numberLength));
                                }
                                catch (NumberFormatException nfe) {
                                    throw this.newModelException("Incorrect big decimal value", nfe);
                                }
                            } else {
                                if (this.buffer[this.position] != 'i') throw this.newModelException("Unexpected first character '" + this.buffer[this.position] + "' while reading DMR decimal or integer token");
                                this.readString(INTEGER);
                                this.processWhitespaces();
                                this.readNumber(false);
                                try {
                                    this.analyzer.putNumber(ModelEvent.BIG_INTEGER);
                                    this.bigIntegerValue = new BigInteger(new String(this.buffer, this.numberOffset, this.numberLength));
                                }
                                catch (NumberFormatException nfe) {
                                    throw this.newModelException("Incorrect big integer value", nfe);
                                }
                            }
                        } else {
                            if (this.buffer[this.position + 1] != 'y') throw this.newModelException("Unexpected second character '" + this.buffer[this.position + 1] + "' while reading DMR big or bytes token");
                            this.analyzer.putBytes();
                            this.readString(BYTES);
                            this.processWhitespaces();
                            this.readBytes();
                        }
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 68: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_DOUBLE);
                        this.typeValue = ModelType.DOUBLE;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 101: {
                        this.analyzer.putExpression();
                        --this.position;
                        this.readString(EXPRESSION);
                        this.processWhitespaces();
                        this.ensureBufferAccess(1);
                        currentChar = this.buffer[this.position++];
                        if (currentChar != 34) {
                            throw this.newModelException("Unexpected character '" + (char)currentChar + "' while reading DMR expression value");
                        }
                        this.readString();
                        this.stringValue = new String(this.buffer, this.stringOffset, this.stringLength);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 69: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_EXPRESSION);
                        this.typeValue = ModelType.EXPRESSION;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 79: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_OBJECT);
                        this.typeValue = ModelType.OBJECT;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 80: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_PROPERTY);
                        this.typeValue = ModelType.PROPERTY;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 83: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_STRING);
                        this.typeValue = ModelType.STRING;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 84: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_TYPE);
                        this.typeValue = ModelType.TYPE;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 85: {
                        this.analyzer.putType();
                        --this.position;
                        this.readString(TYPE_UNDEFINED);
                        this.typeValue = ModelType.UNDEFINED;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 76: {
                        --this.position;
                        this.ensureBufferAccess(2);
                        this.analyzer.putType();
                        if (this.buffer[this.position + 1] == 'I') {
                            this.readString(TYPE_LIST);
                            this.typeValue = ModelType.LIST;
                        } else {
                            if (this.buffer[this.position + 1] != 'O') throw this.newModelException("Unexpected second character '" + this.buffer[this.position + 1] + "' while reading DMR LIST or LONG token");
                            this.readString(TYPE_LONG);
                            this.typeValue = ModelType.LONG;
                        }
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 66: {
                        --this.position;
                        this.ensureBufferAccess(2);
                        this.analyzer.putType();
                        if (this.buffer[this.position + 1] == 'I') {
                            this.ensureBufferAccess(5);
                            if (this.buffer[this.position + 4] == 'D') {
                                this.readString(TYPE_BIG_DECIMAL);
                                this.typeValue = ModelType.BIG_DECIMAL;
                            } else {
                                if (this.buffer[this.position + 4] != 'I') throw this.newModelException("Unexpected fifth character '" + this.buffer[this.position + 4] + "' while reading DMR BIG_DECIMAL or BIG_INTEGER token");
                                this.readString(TYPE_BIG_INTEGER);
                                this.typeValue = ModelType.BIG_INTEGER;
                            }
                        } else if (this.buffer[this.position + 1] == 'O') {
                            this.readString(TYPE_BOOLEAN);
                            this.typeValue = ModelType.BOOLEAN;
                        } else {
                            if (this.buffer[this.position + 1] != 'Y') throw this.newModelException("Unexpected second character '" + this.buffer[this.position + 1] + "' while reading DMR BIG_DECIMAL or BIG_INTEGER or BOOLEAN or BYTES token");
                            this.readString(TYPE_BYTES);
                            this.typeValue = ModelType.BYTES;
                        }
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 73: {
                        --this.position;
                        this.ensureBufferAccess(2);
                        if (this.buffer[this.position + 1] == 'N') {
                            this.analyzer.putType();
                            this.readString(TYPE_INT);
                            this.typeValue = ModelType.INT;
                        } else {
                            if (this.buffer[this.position + 1] != 'n') throw this.newModelException("Unexpected second character '" + this.buffer[this.position + 1] + "' while reading DMR INT or Infinity token");
                            this.readString(INFINITY);
                            this.analyzer.putNumber(ModelEvent.DOUBLE);
                            this.doubleValue = Double.POSITIVE_INFINITY;
                        }
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 78: {
                        --this.position;
                        this.readString(NAN);
                        this.analyzer.putNumber(ModelEvent.DOUBLE);
                        this.doubleValue = Double.NaN;
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 102: 
                    case 116: {
                        this.analyzer.putBoolean();
                        --this.position;
                        this.booleanValue = currentChar == 116;
                        this.readString(this.booleanValue ? TRUE : FALSE);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 117: {
                        this.analyzer.putUndefined();
                        --this.position;
                        this.readString(UNDEFINED);
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 123: {
                        this.analyzer.putObjectStart();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 91: {
                        this.analyzer.putListStart();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 40: {
                        this.analyzer.putPropertyStart();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 125: {
                        this.analyzer.putObjectEnd();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 93: {
                        this.analyzer.putListEnd();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                    case 41: {
                        this.analyzer.putPropertyEnd();
                        ModelEvent modelEvent = this.analyzer.currentEvent;
                        return modelEvent;
                    }
                }
                if (!Utils.isWhitespace(currentChar)) throw this.newModelException("Unexpected character '" + (char)currentChar + "' while reading DMR stream");
                this.processWhitespaces();
                continue;
                break;
            }
            catch (Throwable t) {
                assertEmptyStream = false;
                throw t;
            }
        }
        finally {
            if (this.analyzer.finished && assertEmptyStream) {
                this.processWhitespaces();
                if (this.read() != -1) {
                    throw new ModelException("Unexpected content following the DMR stream");
                }
            }
        }
    }

    private void processWhitespaces() throws IOException {
        char currentChar;
        do {
            if (this.position == this.limit) {
                this.limit = 0;
                this.position = 0;
                this.fillBuffer();
                if (this.position != this.limit) continue;
                return;
            }
            if (this.position != this.limit - 1) continue;
            this.buffer[0] = this.buffer[this.position];
            this.limit = 1;
            this.position = 0;
            this.fillBuffer();
        } while (Utils.isWhitespace(currentChar = this.buffer[this.position++]));
        --this.position;
    }

    private void ensureData() throws IOException {
        if (this.position == this.limit) {
            if (this.limit == this.buffer.length) {
                this.limit = 0;
                this.position = 0;
            }
            this.fillBuffer();
        }
    }

    private void ensureBufferAccess(int charsCount) throws IOException, ModelException {
        if (this.position + charsCount <= this.limit) {
            return;
        }
        if (this.position <= this.limit) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.limit - this.position);
            this.limit -= this.position;
            this.position = 0;
        }
        this.fillBuffer();
        if (this.position + charsCount > this.limit) {
            throw this.newModelException("Unexpected EOF while reading DMR stream");
        }
    }

    private boolean ensureBufferAccessNoFail(int charsCount) throws IOException, ModelException {
        if (this.position + charsCount <= this.limit) {
            return true;
        }
        if (this.position <= this.limit) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.limit - this.position);
            this.limit -= this.position;
            this.position = 0;
        }
        this.fillBuffer();
        return this.position + charsCount <= this.limit;
    }

    private void fillBuffer() throws IOException {
        do {
            int read;
            if ((read = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) == -1) {
                return;
            }
            this.limit += read;
        } while (this.limit != this.buffer.length);
    }

    private int read() throws IOException {
        this.ensureData();
        return this.position < this.limit ? this.buffer[this.position++] : -1;
    }

    private void readString() throws IOException, ModelException {
        boolean escaped = false;
        this.stringLength = 0;
        boolean copy = false;
        do {
            if (this.stringLength == 0) {
                this.stringOffset = this.position;
            }
            while (this.position != this.limit) {
                int currentChar = this.buffer[this.position++];
                if (escaped) {
                    copy = true;
                    this.buffer[this.stringOffset + this.stringLength++] = currentChar == 98 ? 8 : (currentChar == 102 ? 12 : (currentChar == 110 ? 10 : (currentChar == 114 ? 13 : currentChar)));
                    escaped = false;
                    continue;
                }
                if (currentChar == 34) {
                    return;
                }
                if (currentChar == 92) {
                    escaped = true;
                    continue;
                }
                if (copy) {
                    this.buffer[this.stringOffset + this.stringLength] = currentChar;
                }
                ++this.stringLength;
            }
            if (this.stringOffset != 0 && this.stringLength > 0) {
                System.arraycopy(this.buffer, this.stringOffset, this.buffer, 0, this.stringLength);
                this.position = this.stringLength;
                this.limit = this.stringLength;
                this.stringOffset = 0;
            } else if (this.stringOffset == 0 && this.limit == this.buffer.length) {
                this.doubleBuffer();
            }
            this.ensureData();
        } while (this.position != this.limit);
        throw this.newModelException("Unexpected EOF while reading DMR stream");
    }

    private void readString(char[] expected) throws IOException, ModelException {
        int i;
        if (this.position < this.limit - expected.length + 1) {
            for (i = 0; i < expected.length; ++i) {
                if (this.buffer[this.position++] == expected[i]) continue;
                throw this.newModelException("Unexpected character '" + this.buffer[this.position - 1] + "' while reading DMR " + new String(expected) + " token");
            }
        } else {
            while (true) {
                if (this.position < this.limit && i != expected.length) {
                    if (this.buffer[this.position++] == expected[i++]) continue;
                    throw this.newModelException("Unexpected character '" + this.buffer[this.position - 1] + "' while reading DMR " + new String(expected) + " token");
                }
                if (i == expected.length) {
                    return;
                }
                this.ensureData();
                if (this.position == this.limit) break;
            }
            throw this.newModelException("Unexpected EOF while reading DMR stream");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readNumber(boolean hexed) throws IOException, ModelException {
        this.numberOffset = this.position;
        while (true) {
            if (this.position < this.limit) {
                if (hexed ? Utils.isHexNumberChar(this.buffer[this.position++]) : Utils.isNumberChar(this.buffer[this.position++])) continue;
                --this.position;
            }
            this.numberLength = this.position - this.numberOffset;
            if (this.position < this.limit) return;
            if (this.numberOffset != 0) {
                System.arraycopy(this.buffer, this.numberOffset, this.buffer, 0, this.numberLength);
                this.position = this.numberLength;
                this.limit = this.numberLength;
                this.numberOffset = 0;
            } else if (this.limit == this.buffer.length) {
                this.doubleBuffer();
            }
            this.ensureData();
            if (this.position == this.limit) return;
        }
    }

    private void readBytes() throws IOException, ModelException {
        this.ensureBufferAccess(1);
        if (this.buffer[this.position++] != '{') {
            throw this.newModelException("Incorrect bytes value. It must start with: '{'");
        }
        this.processWhitespaces();
        boolean expectingComma = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.ensureBufferAccess(1);
        while (this.buffer[this.position] != '}') {
            if (!expectingComma && Utils.isNumberChar(this.buffer[this.position])) {
                this.ensureBufferAccess(2);
                try {
                    if (this.buffer[this.position + 1] == 'x') {
                        if (this.buffer[this.position] != '0') {
                            throw this.newModelException("Expected integer or hexed integer value inside bytes section");
                        }
                        this.position += 2;
                        this.readNumber(true);
                        baos.write(this.parseHexInt());
                        expectingComma = true;
                    }
                    this.readNumber(false);
                    baos.write(Integer.parseInt(new String(this.buffer, this.numberOffset, this.numberLength)));
                    expectingComma = true;
                }
                catch (NumberFormatException nfe) {
                    throw this.newModelException("Expected integer or hexed integer value inside bytes section", nfe);
                }
            } else if (expectingComma && this.buffer[this.position] == ',') {
                expectingComma = false;
                ++this.position;
            } else {
                if (!expectingComma) {
                    throw this.newModelException("Expected integer or hexed integer value inside bytes section");
                }
                throw this.newModelException("Missing ',' separator inside bytes section");
            }
            this.processWhitespaces();
            this.ensureBufferAccess(1);
        }
        ++this.position;
        this.processWhitespaces();
        this.bytesValue = baos.toByteArray();
    }

    private boolean isDecimalString() {
        int numberLimit = this.numberOffset + this.numberLength;
        for (int i = this.numberOffset; i < numberLimit; ++i) {
            if (this.buffer[i] != '.') continue;
            return true;
        }
        return false;
    }

    private void doubleBuffer() {
        char[] oldData = this.buffer;
        this.buffer = new char[oldData.length * 2];
        System.arraycopy(oldData, 0, this.buffer, 0, oldData.length);
    }

    private ModelException newModelException(String message) throws ModelException {
        throw this.analyzer.newModelException(message);
    }

    private ModelException newModelException(String message, Throwable t) throws ModelException {
        throw this.analyzer.newModelException(message, t);
    }

    private int parseHexInt() throws NumberFormatException {
        if (this.numberLength == 0 || this.numberLength > 8) {
            throw new NumberFormatException("Not an integer value: " + new String(this.buffer, this.numberOffset, this.numberLength));
        }
        if (this.numberLength == 1) {
            return Utils.HEX_TABLE[this.buffer[this.numberOffset]];
        }
        int result = 0;
        for (int i = 0; i < this.numberLength - 1; ++i) {
            result |= Utils.HEX_TABLE[this.buffer[this.numberOffset + i]];
            result <<= 4;
        }
        return result |= Utils.HEX_TABLE[this.buffer[this.numberOffset + this.numberLength - 1]];
    }

    private long parseHexLong() throws NumberFormatException {
        if (this.numberLength == 0 || this.numberLength > 16) {
            throw new NumberFormatException("Not a long value: " + new String(this.buffer, this.numberOffset, this.numberLength));
        }
        if (this.numberLength == 1) {
            return Utils.HEX_TABLE[this.buffer[this.numberOffset]];
        }
        long result = 0L;
        for (int i = 0; i < this.numberLength - 1; ++i) {
            result |= (long)Utils.HEX_TABLE[this.buffer[this.numberOffset + i]];
            result <<= 4;
        }
        return result |= (long)Utils.HEX_TABLE[this.buffer[this.numberOffset + this.numberLength - 1]];
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("DMR reader have been closed");
        }
    }
}

