/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependRejectOptionActivator;

public class OptionActivators {

    public static class FileSystemRoleDecoderActivator
    extends AbstractDependOptionActivator {
        public FileSystemRoleDecoderActivator() {
            super(false, "file-system-realm-name");
        }
    }

    public static class PlainTextActivator
    extends AbstractDependOptionActivator {
        public PlainTextActivator() {
            super(false, "user-properties-file");
        }
    }

    public static class RelativeToActivator
    extends AbstractDependOptionActivator {
        public RelativeToActivator() {
            super(false, "user-properties-file");
        }
    }

    public static class GroupPropertiesFileActivator
    extends AbstractDependOptionActivator {
        public GroupPropertiesFileActivator() {
            super(false, "user-properties-file");
        }
    }

    public static class SuperUserActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return opt != null && opt.value() != null && ElytronUtil.getMechanismsLocalUser().contains(opt.value());
        }
    }

    public static class DependsOnMechanism
    extends AbstractDependOptionActivator {
        public DependsOnMechanism() {
            super(false, "mechanism");
        }
    }

    public static class RolesActivator
    extends AbstractDependOptionActivator {
        public RolesActivator() {
            super(false, "mechanism");
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithTrustStore().contains(opt.value());
        }
    }

    public static class KeyStoreActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public KeyStoreActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithTrustStore().contains(opt.value());
        }

        static {
            REJECTED.addAll(Arrays.asList("key-store-realm-name", "file-system-realm-name", "properties-realm-name", "user-properties-file"));
            EXPECTED.add("mechanism");
        }
    }

    public static class KeyStoreRealmActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public KeyStoreRealmActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithTrustStore().contains(opt.value());
        }

        static {
            REJECTED.addAll(Arrays.asList("key-store-name", "file-system-realm-name", "properties-realm-name", "user-properties-file"));
            EXPECTED.add("mechanism");
        }
    }

    public static class PropertiesFileRealmActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public PropertiesFileRealmActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithRealm().contains(opt.value());
        }

        static {
            REJECTED.addAll(Arrays.asList("file-system-realm-name", "properties-realm-name", "key-store-name", "key-store-realm-name"));
            EXPECTED.add("mechanism");
        }
    }

    public static class PropertiesRealmActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public PropertiesRealmActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithRealm().contains(opt.value());
        }

        static {
            REJECTED.addAll(Arrays.asList("user-properties-file", "file-system-realm-name", "key-store-name", "key-store-realm-name"));
            EXPECTED.add("mechanism");
        }
    }

    public static class FilesystemRealmActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public FilesystemRealmActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithRealm().contains(opt.value());
        }

        static {
            REJECTED.addAll(Arrays.asList("user-properties-file", "properties-realm-name", "key-store-name", "key-store-realm-name"));
            EXPECTED.add("mechanism");
        }
    }

    public static class NewSecurityRealmActivator
    extends AbstractDependOptionActivator {
        public NewSecurityRealmActivator() {
            super(false, "mechanism");
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption mechOption = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            if (ElytronUtil.getMechanismsLocalUser().contains(mechOption.value())) {
                return false;
            }
            ParsedOption optProps = parsedCommand.findLongOptionNoActivatorCheck("user-properties-file");
            if (optProps != null && optProps.value() != null) {
                return true;
            }
            ParsedOption extCert = parsedCommand.findLongOptionNoActivatorCheck("key-store-name");
            return extCert != null && extCert.value() != null;
        }
    }

    public static class MechanismWithRealmActivator
    extends AbstractDependOptionActivator {
        public MechanismWithRealmActivator() {
            super(false, "mechanism");
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (!super.isActivated(parsedCommand)) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("mechanism");
            return ElytronUtil.getMechanismsWithRealm().contains(opt.value());
        }
    }
}

