/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.RealmAccessClaim;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;

public class OidcSecurityRealm
implements SecurityRealm {
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        if (principal instanceof OidcPrincipal) {
            return this.createRealmIdentity((OidcPrincipal)principal);
        }
        return RealmIdentity.NON_EXISTENT;
    }

    private RealmIdentity createRealmIdentity(final OidcPrincipal principal) {
        return new RealmIdentity(){

            public Principal getRealmIdentityPrincipal() {
                return principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.SUPPORTED;
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return principal != null;
            }

            public boolean exists() throws RealmUnavailableException {
                return principal != null;
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                RefreshableOidcSecurityContext securityContext = (RefreshableOidcSecurityContext)principal.getOidcSecurityContext();
                MapAttributes attributes = new MapAttributes();
                Set roles = OidcSecurityRealm.getRolesFromSecurityContext(securityContext);
                attributes.addAll("Roles", (Collection)roles);
                return AuthorizationIdentity.basicIdentity((Attributes)attributes);
            }
        };
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private static Set<String> getRolesFromSecurityContext(RefreshableOidcSecurityContext session) {
        HashSet<String> roles = new HashSet<String>();
        AccessToken accessToken = session.getToken();
        OidcClientConfiguration oidcClientConfig = session.getOidcClientConfiguration();
        if (oidcClientConfig.isUseResourceRoleMappings()) {
            RealmAccessClaim resourceAccessClaim;
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.trace("use resource role mappings");
            }
            if ((resourceAccessClaim = accessToken.getResourceAccessClaim(oidcClientConfig.getResourceName())) != null) {
                roles.addAll(resourceAccessClaim.getRoles());
            }
        }
        if (oidcClientConfig.isUseRealmRoleMappings()) {
            RealmAccessClaim realmAccessClaim;
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.trace("use realm role mappings");
            }
            if ((realmAccessClaim = accessToken.getRealmAccessClaim()) != null) {
                roles.addAll(realmAccessClaim.getRoles());
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("Setting roles: ");
            for (String role : roles) {
                ElytronMessages.log.trace("   role: " + role);
            }
        }
        return roles;
    }
}

