/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectTypeValidator
extends ModelTypeValidator {
    private final Map<String, AttributeDefinition> allowedValues;

    public ObjectTypeValidator(boolean nullable, AttributeDefinition ... attributes) {
        super(nullable, true, false, ModelType.OBJECT, new ModelType[0]);
        this.allowedValues = new HashMap<String, AttributeDefinition>(attributes.length);
        for (AttributeDefinition attribute : attributes) {
            this.allowedValues.put(attribute.getName(), attribute);
        }
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            for (AttributeDefinition ad : this.allowedValues.values()) {
                String key = ad.getName();
                ModelNode toTest = value.has(key) ? value.get(key) : new ModelNode();
                ad.getValidator().validateParameter(key, toTest);
            }
        }
    }
}

