/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.management.ManagementWriteAttributeHandler;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class BaseNativeInterfaceResourceDefinition
extends SimpleResourceDefinition {
    public static final RuntimeCapability<Void> NATIVE_MANAGEMENT_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.native-interface").build();
    protected static final PathElement RESOURCE_PATH = PathElement.pathElement("management-interface", "native-interface");
    public static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setRequires("security-realm")).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setRestartAllServices()).setDeprecated(ModelVersion.create(5))).build();
    public static final SimpleAttributeDefinition SASL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-protocol", ModelType.STRING, true).setRequires("security-realm")).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setDefaultValue(new ModelNode("remote"))).setRestartAllServices()).setDeprecated(ModelVersion.create(5))).build();
    public static final SimpleAttributeDefinition SASL_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-authentication-factory", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.sasl-authentication-factory", NATIVE_MANAGEMENT_RUNTIME_CAPABILITY)).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF)).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.ssl-context", NATIVE_MANAGEMENT_RUNTIME_CAPABILITY)).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.SSL_REF)).build();
    protected static final AttributeDefinition[] COMMON_ATTRIBUTES = new AttributeDefinition[]{SSL_CONTEXT, SERVER_NAME, SASL_PROTOCOL, SASL_AUTHENTICATION_FACTORY};

    protected BaseNativeInterfaceResourceDefinition(SimpleResourceDefinition.Parameters parameters) {
        super(parameters.addAccessConstraints(SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES).addCapabilities(NATIVE_MANAGEMENT_RUNTIME_CAPABILITY).setDeprecatedSince(ModelVersion.create(1, 7)));
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AttributeDefinition[] attributeDefinitions = this.getAttributeDefinitions();
        ManagementWriteAttributeHandler writeHandler = new ManagementWriteAttributeHandler(attributeDefinitions);
        for (AttributeDefinition attr : attributeDefinitions) {
            resourceRegistration.registerReadWriteAttribute(attr, null, writeHandler);
        }
    }

    protected abstract AttributeDefinition[] getAttributeDefinitions();

    protected static AttributeDefinition[] combine(AttributeDefinition[] commonAttributes, AttributeDefinition ... additionalAttributes) {
        AttributeDefinition[] combined = new AttributeDefinition[commonAttributes.length + additionalAttributes.length];
        System.arraycopy(commonAttributes, 0, combined, 0, commonAttributes.length);
        System.arraycopy(additionalAttributes, 0, combined, commonAttributes.length, additionalAttributes.length);
        return combined;
    }
}

