/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDescriptor;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceHandlerBase;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class RestartParentResourceAddHandler
extends RestartParentResourceHandlerBase
implements OperationDescriptor {
    static final Set<? extends AttributeDefinition> NULL_ATTRIBUTES = Collections.emptySet();
    static final Set<RuntimeCapability> NULL_CAPABILITIES = Collections.emptySet();
    protected final Set<RuntimeCapability> capabilities;
    protected final Collection<? extends AttributeDefinition> attributes;

    protected RestartParentResourceAddHandler(String parentKeyName) {
        this(parentKeyName, (Set<RuntimeCapability>)null, (Collection<? extends AttributeDefinition>)null);
    }

    protected RestartParentResourceAddHandler(String parentKeyName, RuntimeCapability ... capabilities) {
        this(parentKeyName, capabilities == null || capabilities.length == 0 ? NULL_CAPABILITIES : Arrays.stream(capabilities).collect(Collectors.toSet()), null);
    }

    public RestartParentResourceAddHandler(String parentKeyName, Set<RuntimeCapability> capabilities, Collection<? extends AttributeDefinition> attributes) {
        super(parentKeyName);
        this.attributes = attributes == null ? NULL_ATTRIBUTES : attributes;
        this.capabilities = capabilities == null ? NULL_CAPABILITIES : capabilities;
    }

    @Override
    public Collection<? extends AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @Override
    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        this.populateModel(operation, resource.getModel());
        this.recordCapabilitiesAndRequirements(context, operation, resource);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        Set<RuntimeCapability> capabilitySet = this.capabilities.isEmpty() ? context.getResourceRegistration().getCapabilities() : this.capabilities;
        for (RuntimeCapability capability : capabilitySet) {
            if (capability.isDynamicallyNamed()) {
                context.registerCapability(capability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(capability);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : this.attributes) {
            if (!model.hasDefined(attributeDefinition.getName()) && !attributeDefinition.hasCapabilityRequirements()) continue;
            attributeDefinition.addCapabilityRequirements(context, resource, model.get(attributeDefinition.getName()));
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }
}

