/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;

public class EnvVarAttributeOverrider {
    private static final boolean ENABLED = System.getenv().containsKey("WILDFLY_OVERRIDING_ENV_VARS");

    static boolean isEnabled() {
        return ENABLED;
    }

    static String getOverriddenValueFromEnvVar(PathAddress address, String attributeName) {
        String envVar = EnvVarAttributeOverrider.replaceNonAlphanumericByUnderscoreAndMakeUpperCase(address, attributeName);
        String envVarValue = System.getenv(envVar);
        if (envVarValue != null) {
            ControllerLogger.ROOT_LOGGER.debugf("The value of the '%s' attribute of the '%s' resource is set by the environment variable '%s'", attributeName, address, envVar);
            return envVarValue;
        }
        return null;
    }

    static String replaceNonAlphanumericByUnderscoreAndMakeUpperCase(PathAddress address, String attributeName) {
        int c;
        String name = address.toCLIStyleString().substring(1) + "__" + attributeName;
        int length = name.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = Character.toUpperCase(name.codePointAt(i));
            if (65 <= c && c <= 90 || 48 <= c && c <= 57) {
                sb.appendCodePoint(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }
}

