/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.resourceadapters.statistics.AdminObjectStatisticsService;
import org.jboss.as.connector.subsystems.resourceadapters.AdminObjectService;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class AdminObjectAdd
extends AbstractAddStepHandler {
    static final AdminObjectAdd INSTANCE = new AdminObjectAdd();

    private AdminObjectAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        for (AttributeDefinition attribute : CommonAttributes.ADMIN_OBJECTS_NODE_ATTRIBUTE) {
            attribute.validateAndSet(operation, modelNode);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModifiableAdminObject adminObjectValue;
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String raName = context.getCurrentAddress().getParent().getLastElement().getValue();
        ModelNode raModel = context.readResourceFromRoot(path.subAddress(0, path.size() - 1), false).getModel();
        boolean statsEnabled = Constants.STATISTICS_ENABLED.resolveModelAttribute(context, raModel).asBoolean();
        if (!raModel.hasDefined(Constants.ARCHIVE.getName()) && !raModel.hasDefined(Constants.MODULE.getName())) {
            throw ConnectorLogger.ROOT_LOGGER.archiveOrModuleRequired();
        }
        String archiveOrModuleName = raModel.get(Constants.ARCHIVE.getName()).isDefined() ? Constants.ARCHIVE.resolveModelAttribute(context, raModel).asString() : Constants.MODULE.resolveModelAttribute(context, raModel).asString();
        String poolName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        try {
            adminObjectValue = RaOperationUtil.buildAdminObjects(context, operation, poolName);
        }
        catch (ValidateException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set(ConnectorLogger.ROOT_LOGGER.failedToCreate("AdminObject", operation, e.getLocalizedMessage())));
        }
        ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName, poolName});
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName});
        ServiceTarget serviceTarget = context.getServiceTarget();
        AdminObjectService service = new AdminObjectService(adminObjectValue);
        serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(raServiceName, ModifiableResourceAdapter.class, service.getRaInjector()).install();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
        Activation raxml = (Activation)RaxmlController.getValue();
        ServiceName deploymentServiceName = ConnectorServices.getDeploymentServiceName(archiveOrModuleName, raName);
        String bootStrapCtxName = "default";
        if (raxml.getBootstrapContext() != null && !raxml.getBootstrapContext().equals("undefined")) {
            bootStrapCtxName = raxml.getBootstrapContext();
        }
        AdminObjectStatisticsService adminObjectStatisticsService = new AdminObjectStatisticsService(context.getResourceRegistrationForUpdate(), poolName, statsEnabled);
        ServiceBuilder statsServiceBuilder = serviceTarget.addService(serviceName.append(new String[]{"STATISTICS"}), (Service)adminObjectStatisticsService);
        statsServiceBuilder.addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{bootStrapCtxName}), Object.class, adminObjectStatisticsService.getBootstrapContextInjector()).addDependency(deploymentServiceName, Object.class, adminObjectStatisticsService.getResourceAdapterDeploymentInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
        PathElement peAO = PathElement.pathElement((String)"statistics", (String)"extended");
        IronJacamarResource.IronJacamarRuntimeResource aoResource = new IronJacamarResource.IronJacamarRuntimeResource();
        resource.registerChild(peAO, (Resource)aoResource);
    }
}

