/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.optimization.impl;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.ExplicitOnlyOptimizerStrategy;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IncrementalOptimizerStrategy
extends ExplicitOnlyOptimizerStrategy
implements OptimizerStrategy {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private int operationMax = -1;
    private int transactionMax = -1;
    private volatile long operations = 0L;
    private volatile long transactions = 0L;
    private volatile long optimizationsPerformed = 0L;
    private final Object lockOnCounters = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performOptimization(IndexWriter writer) {
        boolean done = super.performOptimization(writer);
        if (done) {
            Object object = this.lockOnCounters;
            synchronized (object) {
                this.operations = 0L;
                this.transactions = 0L;
                ++this.optimizationsPerformed;
            }
        }
        return done;
    }

    private boolean needOptimization() {
        return this.operationMax != -1 && this.operations >= (long)this.operationMax || this.transactionMax != -1 && this.transactions >= (long)this.transactionMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOperationWithinTransactionCount(long operations) {
        Object object = this.lockOnCounters;
        synchronized (object) {
            this.operations += operations;
            ++this.transactions;
        }
    }

    @Override
    public void optimize(Workspace workspace) {
        if (this.needOptimization()) {
            log.debugv("Optimize {0} after {1} operations and {2} transactions", this.indexName, this.operations, this.transactions);
            IndexWriter writer = workspace.getIndexWriter();
            try {
                this.performOptimization(writer);
            }
            finally {
                workspace.afterTransactionApplied(false, false);
            }
        }
    }

    @Override
    public void initialize(IndexManager indexManager, Properties indexProperties) {
        super.initialize(indexManager, indexProperties);
        this.operationMax = ConfigurationParseHelper.getIntValue(indexProperties, "operation_limit.max", -1);
        this.transactionMax = ConfigurationParseHelper.getIntValue(indexProperties, "transaction_limit.max", -1);
    }

    public long getOptimizationsPerformed() {
        return this.optimizationsPerformed;
    }
}

