/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;

public abstract class AbstractDelegatingSaslServerFactory
implements SaslServerFactory {
    protected final SaslServerFactory delegate;

    protected AbstractDelegatingSaslServerFactory(SaslServerFactory delegate) {
        this.delegate = (SaslServerFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
    }

    public final boolean delegatesThrough(Class<? extends SaslServerFactory> factoryClass) {
        return factoryClass != null && this.delegatesThroughNN(factoryClass);
    }

    boolean delegatesThroughNN(Class<? extends SaslServerFactory> factoryClass) {
        return factoryClass.isInstance(this) || this.delegate instanceof AbstractDelegatingSaslServerFactory && ((AbstractDelegatingSaslServerFactory)this.delegate).delegatesThroughNN(factoryClass);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.delegate.getMechanismNames(props);
    }

    public String toString() {
        return super.toString() + "->" + this.delegate.toString();
    }
}

